(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1103760,      23841]
NotebookOptionsPosition[   1086129,      23431]
NotebookOutlinePosition[   1087276,      23471]
CellTagsIndexPosition[   1087233,      23468]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.514854752927075*^9, 3.514854752927075*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[StyleBox["Domain Map ",
  FontSize->24]], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.510420573081676*^9, 
   3.510420573081676*^9}, {3.510420642421773*^9, 3.510420642421773*^9}, {
   3.510430918288175*^9, 3.51043092210818*^9}, {3.510430958528231*^9, 
   3.510430958528231*^9}, {3.514435726645997*^9, 3.5144357958633184`*^9}, {
   3.5144359444535794`*^9, 3.514435964172014*^9}, {3.514436016057705*^9, 
   3.514436016057705*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{-4, 0}, {-1, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1 \[LowerRightArrow]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], Rational[5, 2]}, {-2.5, 2.5}]]}, 
   {RGBColor[0.5, 0.5, 1.], RectangleBox[{-1, 0}, {0, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 2 \[DownArrow]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-1, 2], Rational[5, 2]}, {-0.5, 2.5}]]}, 
   {RGBColor[0.5, 0.5, 1.], Thickness[Large], LineBox[{{-1, 3.98}, {-1, 0}}]}, 
   {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
    LineBox[{{-0.98, 3.98}, {-0.98, 0}}], 
    {RGBColor[0, 1, 0], Dashing[{}], RectangleBox[{0, -1}, {4, 4}], 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 3 \[LeftArrow]\"\>",
        StripOnInput->False,
        FontSize->10], NCache[{2, Rational[5, 2]}, {2, 2.5}]]}, 
     {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
      LineBox[{{0.02, -0.98}, {3.98, -0.98}}], 
      {RGBColor[1, 0.5, 0.5], Dashing[{}], RectangleBox[{0, -4}, {4, -1}], 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 4 \[UpperLeftArrow]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{2, Rational[-5, 2]}, {2, -2.5}]]}, 
       {RGBColor[1, 0, 1], RectangleBox[{-1, -4}, {0, -1}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 5 \[UpArrow]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[-1, 2], -2.5}, {-0.5, -2.5}]]}, 
       {RGBColor[1, 0, 1], Thickness[Large], 
        LineBox[{{-1, -1.02}, {-1, -3.98}}]}, 
       {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
        LineBox[{{-0.98, -1.04}, {-0.98, -3.98}}], 
        {RGBColor[1, 0.5, 0], Dashing[{}], RectangleBox[{-4, -4}, {-1, 0}], 
         {GrayLevel[0], InsetBox[
           StyleBox["\<\"Rule 6 \[RightArrow]\"\>",
            StripOnInput->False,
            FontSize->10], NCache[{Rational[-5, 2], -2.5}, {-2.5, -2.5}]]}, 
         {GrayLevel[1], Thickness[Large], LineBox[{{-1, -0.02}, {-1, -1}}]}, 
         {RGBColor[1, 1, 0], Thickness[Large], 
          LineBox[{{0, -3.98}, {0, -1.02}}], 
          {GrayLevel[0], GeometricTransformationBox[InsetBox[
             StyleBox["\<\"Rule 7\[LeftArrow]\[Diamond]\"\>",
              StripOnInput->False,
              FontSize->10], {0.15, -2.5}], {{{0, 1}, {-1, 0}}, Center}]}, 
          {RGBColor[0.6, 0.4, 0.2], Thickness[Large], 
           LineBox[{{0, -1}, {0, 3.98}}], 
           {GrayLevel[0], GeometricTransformationBox[InsetBox[
              StyleBox["\<\"Rule 8\[Diamond]\"\>",
               StripOnInput->False,
               FontSize->10], {0.15, 2}], {{{0, 1}, {-1, 0}}, Center}]}, 
           {RGBColor[0.3, 1., 0.3], Thickness[Large], 
            LineBox[{{-3.98, 0}, {-1, 0}}], 
            {GrayLevel[0], InsetBox[
              StyleBox["\<\"Rule 9 \[RightArrow]\[Diamond]\"\>",
               StripOnInput->False,
               FontSize->10], NCache[{Rational[-5, 2], 0.13}, {-2.5, 0.13}]]}, 
            {RGBColor[0, 0, 1], Thickness[Large], 
             LineBox[{{-1, 0}, {3.98, 0}}], 
             {GrayLevel[0], InsetBox[
               StyleBox["\<\"Rule 10\[Diamond]\"\>",
                StripOnInput->False,
                FontSize->10], {2, 0.13}]}, 
             {RGBColor[0, 1, 1], DiskBox[{-1, 0}, Scaled[Rational[1, 60]]]}, 
             {GrayLevel[0], InsetBox["\<\"a\"\>", {-0.99, 0}]}, 
             {RGBColor[0, 1, 1], DiskBox[{-1, -1}, Scaled[Rational[1, 60]]]}, 
             {GrayLevel[0], InsetBox["\<\"b\"\>", {-0.99, -1}]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{-1, Rational[-1, 2]}, {-1, -0.5}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], 
              InsetBox["\<\"c\"\>", 
               NCache[{-0.99, Rational[-1, 2]}, {-0.99, -0.5}]]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{Rational[-1, 2], -1}, {-0.5, -1}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], InsetBox["\<\"d\"\>", {-0.49, -1}]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{
                Rational[-1, 2], Rational[-1, 2]}, {-0.5, -0.5}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], 
              InsetBox["\<\"e\"\>", 
               NCache[{-0.49, Rational[-1, 2]}, {-0.49, -0.5}]]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{
                Rational[-1, 2], Rational[-3, 2]}, {-0.5, -1.5}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], 
              InsetBox["\<\"f\"\>", 
               NCache[{-0.49, Rational[-3, 2]}, {-0.49, -1.5}]]}, 
             {RGBColor[0, 1, 1], 
              DiskBox[NCache[{
                Rational[-3, 2], Rational[-1, 2]}, {-1.5, -0.5}], Scaled[
               Rational[1, 60]]]}, 
             {GrayLevel[0], 
              InsetBox["\<\"g\"\>", 
               NCache[{-1.49, Rational[-1, 2]}, {-1.49, -0.5}]]}}}}}}}}}}}},
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     RowBox[{"j", " ", "k", " ", "m"}], TraditionalForm]},
  ImageSize->Medium]], "Input",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Legend:",
  FontWeight->"Bold"],
 "\n\[Bullet]  The rule number in a colored region indicates the rule to use \
for integrals in that region.\n\[Bullet]  The rule number next to a colored \
line indicates the rule to use for integrals on that line.\n\[Bullet]  A \
white region or line indicates there is no rule for integrals in that region \
or on that line.\n\[Bullet]  A solid black line indicates integrals on that \
line are handled by rules in another section.\n\[Bullet]  A dashed black line \
on the border of a region indicates integrals on that border are handled by \
the rule for that region.\n\[Bullet]  The arrow(s) following a rule number \
indicates the direction the rule drives integrands in the n\[Cross]m exponent \
plane.\n\[Bullet]  A \[Diamond] following a rule number indicates the rule \
transforms the integrand into a form handled by another section.\n\[Bullet]  \
A red (stop) disk indicates the terminal rule to use for the point at the \
center of the disk.\n\[Bullet]  A cyan disk indicates the non-terminal rule \
to use for the point at the center of the disk."
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvWx2qt8BmVeOAtpmKSBazPxXBoguPqZWAKJ3VvSW
gGje1yvrQXTvPN4WEL3DULwVRHNs1u0G0VVfRSeD6EsSC6eD6FV9WrNAtOHV
+HkgWv9Q6k4QHetWuh9EH7w48QCIdohIPgqin689BaaXtdWcBdEb3DovgOjl
RslXQHQI+4X7IPr7BK7nINq2WwJMfxN6/hpEt0g2vAfRR7xefgbRXudamA4C
6WcX4tlBtAzPSx4QbVPAJwSir/yqkwLROQtY5EG0j6SgFohmi8k0AdH7HrBZ
gOjD1z65gOiAl39dQfTDAstoEB2x+BuY7v4bmg6i5+RVgWkAeVypcw==
  "],
 FontSize->14],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5104205799816856`*^9, 
   3.5104205799816856`*^9}, {3.51042064726178*^9, 3.51042064726178*^9}, {
   3.510430932928196*^9, 3.510430932928196*^9}, {3.5104309690182457`*^9, 
   3.5104309690182457`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "7"}], "-", "8"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, 
   3.5111158844118*^9, {3.512074886134511*^9, 3.512074889914516*^9}, {
   3.515189281445076*^9, 3.5151892822950773`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 7b with ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"A", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "+", "C"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], "=", "0"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
    3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
    3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
    3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
    3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
    3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
    3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
    3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
    3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
    3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
    3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
    3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
    3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
    3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
    3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
    3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
    3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
    3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
    3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
    3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
    3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
    3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
    3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
    3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
    3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
    3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
    3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
    3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
    3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
    3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
    3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, 
    3.505344641443784*^9, {3.505344693233857*^9, 3.5053447150538874`*^9}, 
    3.5053535583452115`*^9, {3.509473422445426*^9, 3.5094734793846827`*^9}, {
    3.509473628380205*^9, 3.5094737191313953`*^9}, {3.509934575406659*^9, 
    3.5099346370467453`*^9}, {3.509934700046834*^9, 3.509934715466855*^9}, {
    3.50993518320751*^9, 3.5099351838075113`*^9}, {3.5099363262591105`*^9, 
    3.5099363264391108`*^9}, {3.5099363592291565`*^9, 
    3.5099363711991735`*^9}, {3.509936458759296*^9, 3.509936480679327*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236918158064`*^9, 3.5017236959186134`*^9}, 
   3.503014859355447*^9, {3.50301718243629*^9, 3.5030172032263184`*^9}, 
   3.505677202804861*^9, {3.5099345182965794`*^9, 3.5099345191065807`*^9}, {
   3.5099388060165844`*^9, 3.5099388108265915`*^9}, {3.5099825817375135`*^9, 
   3.509982604527546*^9}, 3.512064149082242*^9, 3.5141618277480545`*^9, {
   3.514161889528141*^9, 3.5141618908081427`*^9}, {3.514852874522975*^9, 
   3.514852881527387*^9}, {3.517004396712429*^9, 3.51700440303044*^9}}],

Cell[TextData[{
 "Rule 7a: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{"A", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", "C"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, 3.50993851024617*^9, 
   3.509982467717354*^9, {3.51016913209204*^9, 3.51016913209204*^9}, {
   3.5101701908549356`*^9, 3.5101701908549356`*^9}, {3.5104308159080315`*^9, 
   3.5104308165080323`*^9}, {3.5104512814432535`*^9, 
   3.5104512826132545`*^9}, {3.51207648865281*^9, 3.5120764894028115`*^9}, 
   3.512076647043032*^9, 3.514852964035932*^9, {3.5148630622076383`*^9, 
   3.5148630622076383`*^9}, {3.5170044468353167`*^9, 3.517004462981345*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"A", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k"}]}]]}], 
      RowBox[{"d", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", " ", "k", " ", "m"}], "+", 
         FractionBox[
          RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, 
   3.505344641443784*^9, {3.505344693233857*^9, 3.5053447150538874`*^9}, 
   3.5053535583452115`*^9, {3.509473422445426*^9, 3.5094734793846827`*^9}, {
   3.509473628380205*^9, 3.5094737191313953`*^9}, {3.509934575406659*^9, 
   3.5099346370467453`*^9}, {3.509934700046834*^9, 3.509934715466855*^9}, {
   3.50993518320751*^9, 3.5099351838075113`*^9}, {3.5099363262591105`*^9, 
   3.5099363264391108`*^9}, {3.5099363592291565`*^9, 
   3.5099363711991735`*^9}, {3.509936458759296*^9, 3.509936480679327*^9}, {
   3.5099824773473673`*^9, 3.509982479847371*^9}, {3.510168995193799*^9, 
   3.5101690146158333`*^9}, {3.5101701445048704`*^9, 
   3.5101701628448963`*^9}, {3.514852971461545*^9, 3.514852977451956*^9}, {
   3.5151892830050783`*^9, 3.51518928441508*^9}, {3.5170046191064196`*^9, 
   3.5170046276708345`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"A", "*", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", "*", "x"}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", 
         RowBox[{"k2", "/", "2"}]}]}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", 
          RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
        ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{
       RowBox[{"k2", "^", "2"}], "/", "4"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", "C"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", 
          RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
        ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.5004320294293013`*^9, 3.5004320304863615`*^9}, {3.501043261265483*^9, 
   3.501043262773569*^9}, 3.50267712088142*^9, {3.5026774368118625`*^9, 
   3.502677454531887*^9}, 3.502765652732217*^9, 3.502767119506794*^9, {
   3.503071848758074*^9, 3.503071858708088*^9}, {3.503071992168275*^9, 
   3.5030719924982753`*^9}, {3.5035495943210974`*^9, 
   3.5035496113511214`*^9}, {3.504156566262847*^9, 3.5041565676356487`*^9}, 
   3.505344641463784*^9, {3.505344693263857*^9, 3.505344715073887*^9}, 
   3.505353560095214*^9, 3.50947378686127*^9, {3.509473818845099*^9, 
   3.509473822845328*^9}, 3.5094739102633276`*^9, 3.5099352328575797`*^9, 
   3.5099352665776267`*^9, 3.509935343097734*^9, {3.5099360765987606`*^9, 
   3.509936089578779*^9}, {3.509936331219117*^9, 3.5099363345691223`*^9}, {
   3.5099367605397186`*^9, 3.5099367912097616`*^9}, 3.5099369943300457`*^9, 
   3.509937955293392*^9, 3.5099380487735233`*^9, {3.5099825033374043`*^9, 
   3.509982545787463*^9}, {3.5101694791302495`*^9, 3.5101695343511467`*^9}, 
   3.5101697196926184`*^9, {3.510170231334992*^9, 3.510170257565029*^9}, {
   3.5101702905550747`*^9, 3.51017031563511*^9}, {3.510180398265382*^9, 
   3.5101804071105967`*^9}, {3.5104513452233424`*^9, 3.510451349303348*^9}, {
   3.5104519547341957`*^9, 3.5104519575741997`*^9}, {3.510605414545495*^9, 
   3.510605449083956*^9}, {3.5148531291466217`*^9, 3.5148531635290823`*^9}, 
   3.5168210722470446`*^9, 3.5168560852828016`*^9, {3.5170046477324696`*^9, 
   3.517004669219708*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: ",
 "Rule",
 " 5 with ",
 Cell[BoxData[
  RowBox[{"a", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "=", "0"}]]],
 " and  ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236918158064`*^9, 3.5017236959186134`*^9}, 
   3.503014859355447*^9, {3.50301718243629*^9, 3.5030172032263184`*^9}, 
   3.505677202804861*^9, {3.5099345182965794`*^9, 3.5099345191065807`*^9}, 
   3.512074581944085*^9, 3.5141617514879475`*^9}],

Cell[TextData[{
 "Rule 7b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], "  ", "\[And]",
      " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
      RowBox[{"-", "1", " "}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, {3.5004320341975737`*^9, 
   3.5004320353096375`*^9}, {3.5026784535032854`*^9, 3.502678461573297*^9}, {
   3.5027657904804587`*^9, 3.5027657904804587`*^9}, {3.5027672190193686`*^9, 
   3.5027672190193686`*^9}, {3.5035496199411335`*^9, 
   3.5035496486311736`*^9}, {3.504028649276944*^9, 3.5040286502597466`*^9}, 
   3.50403187501501*^9, 3.5043107662485094`*^9, {3.5047476342426376`*^9, 
   3.504747635372639*^9}, {3.509473798840955*^9, 3.509473798840955*^9}, {
   3.509934658346775*^9, 3.5099346733567963`*^9}, {3.510168158923555*^9, 
   3.510168158923555*^9}, {3.510168267736122*^9, 3.510168267736122*^9}, {
   3.510180258145935*^9, 3.5101802587855363`*^9}, {3.5104308582880907`*^9, 
   3.5104308586880913`*^9}, {3.510596640441908*^9, 3.5105966430919113`*^9}, {
   3.510956586430315*^9, 3.510956589360319*^9}, {3.5109573705414124`*^9, 
   3.510957375331419*^9}, {3.5109574568315334`*^9, 3.5109574568315334`*^9}, {
   3.510957687211856*^9, 3.510957687211856*^9}, {3.511721381465141*^9, 
   3.511721381465141*^9}, {3.512074892244519*^9, 3.5120748931145205`*^9}, 
   3.5148527683959885`*^9, {3.51486309226768*^9, 3.514863124187725*^9}, {
   3.517004120641944*^9, 3.517004132653965*^9}, {3.517004362813569*^9, 
   3.5170043635779705`*^9}, {3.517071668180769*^9, 3.5170716882112045`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"j", " ", "k", " ", "m"}], "+", 
             FractionBox[
              RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], " ", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, 
   3.505344641443784*^9, {3.505344693233857*^9, 3.5053447150538874`*^9}, 
   3.5053535583452115`*^9, {3.509473422445426*^9, 3.5094734793846827`*^9}, {
   3.509473628380205*^9, 3.5094737191313953`*^9}, {3.509934575406659*^9, 
   3.5099346370467453`*^9}, {3.509934700046834*^9, 3.509934715466855*^9}, {
   3.50993518320751*^9, 3.5099351838075113`*^9}, {3.5101685472650127`*^9, 
   3.5101685740814595`*^9}, {3.5148525681848364`*^9, 
   3.5148525706496406`*^9}, {3.5148529881223745`*^9, 3.514853026560842*^9}, {
   3.515189299245101*^9, 3.515189300965103*^9}, {3.5168552687941008`*^9, 
   3.5168554116942744`*^9}, {3.517004483854182*^9, 3.517004505943821*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"A", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "\[NotEqual]", "0"}], 
    " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.5004320294293013`*^9, 3.5004320304863615`*^9}, {3.501043261265483*^9, 
   3.501043262773569*^9}, 3.50267712088142*^9, {3.5026774368118625`*^9, 
   3.502677454531887*^9}, 3.502765652732217*^9, 3.502767119506794*^9, {
   3.503071848758074*^9, 3.503071858708088*^9}, {3.503071992168275*^9, 
   3.5030719924982753`*^9}, {3.5035495943210974`*^9, 
   3.5035496113511214`*^9}, {3.504156566262847*^9, 3.5041565676356487`*^9}, 
   3.505344641463784*^9, {3.505344693263857*^9, 3.505344715073887*^9}, 
   3.505353560095214*^9, 3.50947378686127*^9, {3.509473818845099*^9, 
   3.509473822845328*^9}, 3.5094739102633276`*^9, 3.5099352328575797`*^9, 
   3.5099352665776267`*^9, 3.509935343097734*^9, {3.5099360765987606`*^9, 
   3.509936089578779*^9}, {3.5099369144199343`*^9, 3.5099369145899343`*^9}, 
   3.509936945449977*^9, 3.5099379641334047`*^9, 3.509938088693579*^9, 
   3.5101681784135823`*^9, 3.510168216223635*^9, {3.5101682717141294`*^9, 
   3.5101682917601643`*^9}, {3.510168826567903*^9, 3.510168880091597*^9}, 
   3.5101802628727436`*^9, {3.51059662740189*^9, 3.510596630481894*^9}, 
   3.5105980295970974`*^9, 3.510600582480671*^9, {3.510613402427125*^9, 
   3.510613403441127*^9}, {3.5106138756507564`*^9, 3.510613877117159*^9}, {
   3.51061413409321*^9, 3.5106141358872137`*^9}, {3.5106148344252405`*^9, 
   3.5106148366092443`*^9}, {3.5106260289570074`*^9, 3.510626031328212*^9}, {
   3.5106267288246365`*^9, 3.510626766685903*^9}, {3.5109565631002817`*^9, 
   3.5109565754202995`*^9}, {3.5109572737812767`*^9, 3.510957299361313*^9}, {
   3.5148532539156413`*^9, 3.5148533018545256`*^9}, {3.514863197847828*^9, 
   3.5148632067378407`*^9}, {3.514863282667947*^9, 3.5148633052979784`*^9}, {
   3.516666311611127*^9, 3.5166663180851383`*^9}, 3.516820779246634*^9, {
   3.5168554257270775`*^9, 3.516855469876602*^9}, {3.5168559696271863`*^9, 
   3.516855978554697*^9}, {3.5170041444943857`*^9, 3.5170041478015914`*^9}, {
   3.5170045336026692`*^9, 3.5170045589215136`*^9}, {3.517071627043497*^9, 
   3.5170716414111223`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", 
          RowBox[{"k2", "/", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", 
           RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
         ")"}]}], ")"}]}]}], " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"A", "+", "C"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"j", "*", 
             RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
           ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", 
          RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
        ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"j", "*", "k2"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{
       RowBox[{"k2", "^", "2"}], "/", "4"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", 
       RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
     "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", 
      RowBox[{"k2", "/", "2"}], "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.5004320294293013`*^9, 3.5004320304863615`*^9}, {3.501043261265483*^9, 
   3.501043262773569*^9}, 3.50267712088142*^9, {3.5026774368118625`*^9, 
   3.502677454531887*^9}, 3.502765652732217*^9, 3.502767119506794*^9, {
   3.503071848758074*^9, 3.503071858708088*^9}, {3.503071992168275*^9, 
   3.5030719924982753`*^9}, {3.5035495943210974`*^9, 
   3.5035496113511214`*^9}, {3.504156566262847*^9, 3.5041565676356487`*^9}, 
   3.505344641463784*^9, {3.505344693263857*^9, 3.505344715073887*^9}, 
   3.505353560095214*^9, 3.50947378686127*^9, {3.509473818845099*^9, 
   3.509473822845328*^9}, 3.5094739102633276`*^9, 3.5099352328575797`*^9, 
   3.5099352665776267`*^9, 3.509935343097734*^9, {3.5099360765987606`*^9, 
   3.509936089578779*^9}, {3.509936331219117*^9, 3.5099363345691223`*^9}, {
   3.5099367605397186`*^9, 3.5099367912097616`*^9}, 3.5099369943300457`*^9, 
   3.509937955293392*^9, 3.5099380487735233`*^9, {3.5101694810802526`*^9, 
   3.5101695071478987`*^9}, {3.510169538422754*^9, 3.510169539421156*^9}, 
   3.5101697019825935`*^9, {3.510169769702688*^9, 3.5101697715426908`*^9}, {
   3.510169838607993*^9, 3.510169944391779*^9}, {3.5101700099946823`*^9, 
   3.5101700128046865`*^9}, 3.510170231994993*^9, 3.510180343228485*^9, {
   3.510181019583273*^9, 3.5101810205192747`*^9}, {3.5105967045919976`*^9, 
   3.5105967072820015`*^9}, 3.5106079689063816`*^9, {3.510956796590609*^9, 
   3.5109567996506133`*^9}, {3.5109568340306616`*^9, 3.510956834310662*^9}, {
   3.510957620271762*^9, 3.510957646061798*^9}, {3.514853190969531*^9, 
   3.514853239563616*^9}, {3.514863217007855*^9, 3.5148632598279147`*^9}, {
   3.5148633162179937`*^9, 3.5148633166479945`*^9}, {3.5166663874896603`*^9, 
   3.5166663914988675`*^9}, 3.5168210722770443`*^9, {3.516855594580735*^9, 
   3.5168556863249826`*^9}, {3.5168557559029617`*^9, 3.516855823476827*^9}, {
   3.516855952092183*^9, 3.516855955499378*^9}, {3.516856014569757*^9, 
   3.5168560186179886`*^9}, 3.5168560951243644`*^9, {3.517004332565116*^9, 
   3.5170043344527197`*^9}, {3.517004580262351*^9, 3.517004599871586*^9}, {
   3.5170714468319807`*^9, 3.5170714610124054`*^9}, {3.517071537280939*^9, 
   3.517071545065353*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.5170042604149895`*^9}],

Cell[TextData[{
 "Derivation: ",
 "Rule",
 " 2 with ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "=", "1"}]]],
 " and  ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236216156826`*^9, 3.5017236304920983`*^9}, 
   3.5053451045044327`*^9, 3.5099355636080427`*^9, 3.51207454974404*^9, 
   3.514161756817955*^9}],

Cell[TextData[{
 "Rule 8: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "3"}], "2"]}], "\[NotEqual]", "0"}], "  ", "\[And]",
      " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5035497928813753`*^9, 
   3.5035497928813753`*^9}, {3.504028634534919*^9, 3.504028634831319*^9}, 
   3.5040318640169907`*^9, 3.504310747731277*^9, {3.5047475946625824`*^9, 
   3.5047475961225843`*^9}, {3.5094724358949986`*^9, 
   3.5094724358949986`*^9}, {3.5099355932880845`*^9, 3.509935623998127*^9}, {
   3.5099359647786045`*^9, 3.509935966718607*^9}, {3.5101681618035593`*^9, 
   3.5101681618035593`*^9}, {3.510180270672757*^9, 3.5101802711719584`*^9}, {
   3.5104308624480968`*^9, 3.510430862698097*^9}, {3.51044631163595*^9, 
   3.5104463120571513`*^9}, {3.5105975904364824`*^9, 3.510597594446488*^9}, {
   3.5106139105324173`*^9, 3.510613914323224*^9}, {3.510626053979451*^9, 
   3.510626057645458*^9}, {3.5109567018204765`*^9, 3.510956707690484*^9}, {
   3.51095715452111*^9, 3.5109571591211166`*^9}, {3.5109573432813745`*^9, 
   3.5109573507713847`*^9}, {3.5117213884151506`*^9, 
   3.5117213884151506`*^9}, {3.512074894894523*^9, 3.5120748960145245`*^9}, 
   3.514852669647414*^9, {3.514853665366364*^9, 3.514853665366364*^9}, {
   3.5148630079075623`*^9, 3.514863011437567*^9}, {3.5170041695324297`*^9, 
   3.517004184068455*^9}, 3.517004367275177*^9, {3.517071766523342*^9, 
   3.517071776288959*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "3"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", "C"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{"B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.509935662248181*^9, 3.50993575474831*^9}, {
   3.509935798248371*^9, 3.5099358762884803`*^9}, {3.5101685862026806`*^9, 
   3.5101686092595215`*^9}, 3.5101687286621313`*^9, {3.5148525608840237`*^9, 
   3.5148525638792286`*^9}, {3.5148530763561296`*^9, 3.514853108024185*^9}, {
   3.5151893101451163`*^9, 3.5151893158651247`*^9}, {3.51700475556586*^9, 
   3.5170048157819653`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{"A", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "\[NotEqual]", "0"}], 
    " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509935641248152*^9, 3.5099360663587465`*^9, {3.50993609727879*^9, 
   3.5099361060888023`*^9}, 3.509936656089572*^9, {3.5099369183699393`*^9, 
   3.50993691871994*^9}, 3.5099379645334053`*^9, 3.50993808941358*^9, 
   3.5101681808935857`*^9, 3.5101682193136396`*^9, {3.5101682953637705`*^9, 
   3.510168297376174*^9}, {3.510168831076311*^9, 3.510168832698714*^9}, {
   3.510168890886816*^9, 3.5101689048488407`*^9}, 3.5101802783323708`*^9, {
   3.5104463040387373`*^9, 3.51044630558314*^9}, {3.5105975663164487`*^9, 
   3.510597575036461*^9}, {3.510613408511136*^9, 3.510613411662341*^9}, 
   3.510613593571061*^9, {3.510613850862313*^9, 3.5106138535143175`*^9}, {
   3.5106260362110205`*^9, 3.5106260404542274`*^9}, {3.510626864466875*^9, 
   3.5106268767440968`*^9}, {3.510626932136594*^9, 3.510626932791795*^9}, {
   3.5109567232705064`*^9, 3.5109567250505085`*^9}, {3.5109571734411364`*^9, 
   3.510957185541154*^9}, {3.5109572460312386`*^9, 3.5109572479512405`*^9}, {
   3.5148534196035323`*^9, 3.514853495528866*^9}, 3.5148536845231977`*^9, {
   3.5148630252775865`*^9, 3.51486302765759*^9}, {3.5148633116779876`*^9, 
   3.514863312127988*^9}, 3.5166663511727967`*^9, 3.516820779306634*^9, {
   3.5168561649643593`*^9, 3.5168561666784573`*^9}, {3.516856204281608*^9, 
   3.5168562070687675`*^9}, {3.5170041617012157`*^9, 
   3.5170041638072195`*^9}, {3.5170047395602317`*^9, 3.517004752133854*^9}, {
   3.5170048255319824`*^9, 3.5170048593060417`*^9}, {3.517071797442596*^9, 
   3.5170717976297965`*^9}, {3.5170718441490784`*^9, 3.517071848002285*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", 
          RowBox[{"k2", "/", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", 
           RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k2", "/", "2"}], "+", "3"}], ")"}], "/", "2"}]}], 
         ")"}]}], ")"}]}]}], " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"A", "+", "C"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"j", "*", 
             RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k2", "/", "2"}], "+", "1"}], ")"}], "/", "2"}]}], 
           ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", 
          RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k2", "/", "2"}], "+", "3"}], ")"}], "/", "2"}]}], 
        ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{
       RowBox[{"k2", "^", "2"}], "/", "4"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", 
       RowBox[{"k2", "/", "2"}], "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k2", "/", "2"}], "+", "3"}], ")"}], "/", "2"}]}], 
     "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", 
      RowBox[{"k2", "/", "2"}], "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509935641248152*^9, 3.5099360663587465`*^9, {3.50993609727879*^9, 
   3.5099361060888023`*^9}, {3.5099363432191343`*^9, 3.509936349269143*^9}, {
   3.5099367980497713`*^9, 3.509936798229771*^9}, 3.5099368489198422`*^9, 
   3.5099370012100554`*^9, 3.5099379560633936`*^9, {3.509938152173668*^9, 
   3.5099381655336866`*^9}, {3.5101694831394567`*^9, 
   3.5101695078499002`*^9}, {3.510169543102762*^9, 3.510169543960764*^9}, {
   3.5101696293224916`*^9, 3.510169665402542*^9}, {3.510169776672698*^9, 
   3.5101697784427004`*^9}, {3.510170042654728*^9, 3.510170082724784*^9}, 
   3.5101702325849943`*^9, 3.510180346613691*^9, {3.5101810417041116`*^9, 
   3.5101810423749127`*^9}, 3.5104499203013477`*^9, {3.5106062181777067`*^9, 
   3.5106062324517317`*^9}, {3.5106062717638006`*^9, 3.510606275289407*^9}, {
   3.510606667052895*^9, 3.510606668113697*^9}, {3.510956821570644*^9, 
   3.510956826690651*^9}, {3.5109575299916353`*^9, 3.510957567291688*^9}, {
   3.5148533252233667`*^9, 3.5148534094323144`*^9}, {3.5148537042572327`*^9, 
   3.5148537166748543`*^9}, {3.514862993407542*^9, 3.514862995787545*^9}, {
   3.5148633081179824`*^9, 3.514863308567983*^9}, {3.5166663692688284`*^9, 
   3.516666376382441*^9}, 3.5168210723470445`*^9, 3.516856095764401*^9, {
   3.5168561592420316`*^9, 3.516856161588166*^9}, {3.516856210405958*^9, 
   3.516856214548195*^9}, {3.517004282301828*^9, 3.517004283955431*^9}, {
   3.517004893548102*^9, 3.517004974309444*^9}, {3.5170717935893893`*^9, 
   3.5170718285646505`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["k", "2"], "=", "1"}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5104193993820252`*^9, 
   3.5104193993820252`*^9}, {3.5104195441222277`*^9, 
   3.5104195441222277`*^9}, {3.5148547580282836`*^9, 3.5148547580282836`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["a",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, {
   3.512256142654321*^9, 3.512256144947525*^9}, {3.5122561871143994`*^9, 
   3.512256229733674*^9}, {3.5144137669500422`*^9, 3.514413768119109*^9}, {
   3.5144144744945116`*^9, 3.5144144750495434`*^9}, {3.514639260152827*^9, 
   3.514639265176036*^9}, {3.514639840063845*^9, 3.5146398408438463`*^9}, 
   3.5146417425491877`*^9, {3.515189323655135*^9, 3.5151893247451367`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox["z", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"C", " ", "z"}], "b"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "B"}], "-", 
         RowBox[{"a", " ", "C"}]}], ")"}], "z"}]}], 
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.510456932005166*^9, 3.510456936635173*^9}, {
   3.514639507845662*^9, 3.5146395462373295`*^9}, {3.5146406390296493`*^9, 
   3.5146406403868513`*^9}, 3.5146406745041113`*^9, {3.5146408395524015`*^9, 
   3.5146408744496627`*^9}}],

Cell["Rule a1:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.4979894880299215`*^9, 3.4979894894339237`*^9}, {3.5043655322225885`*^9, 
   3.50436553318259*^9}, 3.5043711377624407`*^9, 3.504469700248499*^9, 
   3.504986690178133*^9, {3.5104560807139745`*^9, 3.5104560807139745`*^9}, {
   3.5104568937951126`*^9, 3.5104568953851147`*^9}, {3.510505219757546*^9, 
   3.5105052199759464`*^9}, {3.512254387989639*^9, 3.5122543889880404`*^9}, 
   3.512255731234799*^9, {3.5122561484263315`*^9, 3.512256149221933*^9}, {
   3.5146398247134185`*^9, 3.5146398470994577`*^9}, {3.5147575568690825`*^9, 
   3.5147575579890842`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"b", " ", "d"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"a", " ", "C"}]}], ")"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.5053446902338524`*^9, 3.5053446902338524`*^9}, {3.509895243243688*^9, 
   3.5098952441236897`*^9}, {3.510456131784046*^9, 3.5104561346040497`*^9}, {
   3.5104568997651215`*^9, 3.5104569042851276`*^9}, {3.5146393838566437`*^9, 
   3.514639386742649*^9}, {3.5146394495015593`*^9, 3.514639464586786*^9}, 
   3.5146401140419273`*^9, 3.514640588703961*^9, {3.514640885868883*^9, 
   3.5146409199237423`*^9}, {3.515189325675138*^9, 3.5151893275451403`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "B"}], "-", 
              RowBox[{"a", "*", "C"}]}], ")"}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
      "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5053446902438526`*^9, 3.5053446902538524`*^9}, {3.509895249233697*^9, 
   3.5098952515737*^9}, 3.509897436117895*^9, 3.5104305387476435`*^9, 
   3.5104337771841784`*^9, {3.510456046673927*^9, 3.510456071713962*^9}, {
   3.5104568899251075`*^9, 3.5104569155951433`*^9}, 3.510505721922428*^9, {
   3.512256405077982*^9, 3.512256405608383*^9}, 3.51304661790802*^9, 
   3.5130469591284976`*^9, {3.513609435095108*^9, 3.513609444673525*^9}, {
   3.5136099353074865`*^9, 3.5136099484375052`*^9}, {3.514639593287012*^9, 
   3.5146396001198235`*^9}, 3.5146398207978115`*^9, {3.514639887519129*^9, 
   3.5146399355828133`*^9}, 3.51464105505118*^9, 3.5166715582855444`*^9, 
   3.516835973279935*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "C", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}], 
     ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5053446902438526`*^9, 3.5053446902538524`*^9}, {3.509895249233697*^9, 
   3.5098952515737*^9}, 3.509897436117895*^9, 3.5104305387476435`*^9, 
   3.5104337771841784`*^9, {3.510456046673927*^9, 3.510456071713962*^9}, {
   3.5104568899251075`*^9, 3.5104569155951433`*^9}, 3.510505721922428*^9, {
   3.512256405077982*^9, 3.512256405608383*^9}, 3.51304661790802*^9, 
   3.5130469591284976`*^9, {3.513609435095108*^9, 3.513609444673525*^9}, {
   3.5136099353074865`*^9, 3.5136099484375052`*^9}, {3.514639593287012*^9, 
   3.5146396001198235`*^9}, 3.5146398207978115`*^9, {3.514639887519129*^9, 
   3.5146399355828133`*^9}, {3.51464105505118*^9, 3.5146410842232313`*^9}, {
   3.5146723173863244`*^9, 3.5146723296463413`*^9}, {3.5146725738966837`*^9, 
   3.5146725958667145`*^9}, 3.516671546164323*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.5002620149595757`*^9, {3.5119822460882673`*^9, 
   3.5119822484344015`*^9}, {3.5136162015793257`*^9, 3.513616203076928*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox["z", 
       RowBox[{"-", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox["z", 
       RowBox[{"-", "2"}]]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", 
       RowBox[{"-", "1"}]]}]}]], "=", 
   RowBox[{
    FractionBox["A", "a"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", " ", "C"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "A"}], "-", 
         RowBox[{"a", " ", "B"}]}], ")"}], " ", "z"}]}], 
     RowBox[{"a", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.513616405877284*^9, 3.513616440509345*^9}, {
   3.514227599061671*^9, 3.514227623725314*^9}, {3.5142279903259583`*^9, 
   3.514227992681562*^9}, {3.5142281795386906`*^9, 3.514228186465102*^9}, {
   3.514228222267165*^9, 3.514228224466769*^9}}],

Cell[TextData[{
 "Rule a2: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4982408115335917`*^9, 
   3.4982408115335917`*^9}, {3.504396309416292*^9, 3.5043963109862947`*^9}, {
   3.504413193550866*^9, 3.5044131942308674`*^9}, {3.5044133130510335`*^9, 
   3.504413313411034*^9}, {3.508348841306343*^9, 3.508348842436345*^9}, {
   3.513095047017943*^9, 3.5130950482379446`*^9}, {3.513377117822339*^9, 
   3.51337711822234*^9}, {3.514597917336328*^9, 3.5145979175763283`*^9}, {
   3.5145980146964645`*^9, 3.5145980151564655`*^9}, {3.5147364697159986`*^9, 
   3.5147364746612077`*^9}, {3.5147576755792484`*^9, 3.5147576761892495`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", " ", "x"}], "a"]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"C", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "-", 
         RowBox[{"b", " ", 
          RowBox[{"A", "/", "a"}]}]}], ")"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, {3.5107941453949833`*^9, 3.5107941500049896`*^9}, {
   3.5119771197170563`*^9, 3.5119771289415836`*^9}, {3.5119771901660852`*^9, 
   3.511977201231718*^9}, {3.511977716092167*^9, 3.511977740172544*^9}, {
   3.514228039918445*^9, 3.514228057593276*^9}, {3.5142280888869314`*^9, 
   3.514228135577813*^9}, 3.5142282080867405`*^9, {3.514672388346424*^9, 
   3.5146724187764664`*^9}, {3.515189342745162*^9, 3.5151893660851946`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "+", " ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"B", "-", 
            RowBox[{"b", "*", 
             RowBox[{"A", "/", "a"}]}]}], ")"}], "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510794163895009*^9, 3.510794191825048*^9}, {3.510799222156905*^9, 
   3.51079923293692*^9}, {3.5107997631276627`*^9, 3.5107997707176733`*^9}, {
   3.5119751566217732`*^9, 3.511975166603344*^9}, {3.5119773763147326`*^9, 
   3.511977414069892*^9}, {3.511977770474277*^9, 3.5119777943976455`*^9}, 
   3.5136238769667764`*^9, 3.514228331498557*^9, 3.514228377971039*^9, 
   3.5142284547543736`*^9, 3.5142599325071144`*^9, 3.5146397041252065`*^9, {
   3.5146724267064776`*^9, 3.5146724713565397`*^9}, 3.514757729719324*^9, 
   3.516671541967916*^9, 3.517077990950482*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "+", " ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "-", 
         RowBox[{"b", "*", 
          RowBox[{"A", "/", "a"}], "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510794163895009*^9, 3.510794191825048*^9}, {3.510799222156905*^9, 
   3.51079923293692*^9}, {3.5107997631276627`*^9, 3.5107997707176733`*^9}, {
   3.5119751566217732`*^9, 3.511975166603344*^9}, {3.5119773763147326`*^9, 
   3.511977414069892*^9}, 3.513624047428276*^9, {3.5142283363345656`*^9, 
   3.514228348549387*^9}, 3.514228380794644*^9, 3.51422845829558*^9, 
   3.5142599289871097`*^9, 3.514639699523198*^9, 3.514672186856142*^9, {
   3.514672220826189*^9, 3.514672270356259*^9}, 3.514757730909326*^9, 
   3.5166715399399123`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.5148521208540506`*^9, 3.514852122242453*^9}, {3.515189377545211*^9, 
   3.5151893845552206`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.5106050409560385`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox["z"], 
      SqrtBox[
       RowBox[{"1", "/", "z"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.5106050833413134`*^9, 3.510605087834121*^9}, 
   3.51060524079239*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["n", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, 
   3.5142558168413525`*^9, {3.514591220365104*^9, 3.5145912332651224`*^9}, {
   3.5146039606247888`*^9, 3.514603969234801*^9}, {3.5146381054251976`*^9, 
   3.514638105659198*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], ")"}], 
      RowBox[{"n", "/", "2"}]]}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"C", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{
        RowBox[{"n", "/", "2"}], "+", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5105110545409946`*^9, 3.510511103852681*^9}, {
   3.51051176345304*^9, 3.5105117985999017`*^9}, {3.5106043728536654`*^9, 
   3.510604416424542*^9}, {3.51060446662543*^9, 3.5106045234095297`*^9}, {
   3.5106045874476423`*^9, 3.5106045904272475`*^9}, {3.5106049685875115`*^9, 
   3.5106049732519197`*^9}, {3.5106072743463616`*^9, 
   3.5106072866703835`*^9}, {3.5111159289218626`*^9, 3.511115930821865*^9}, {
   3.514163132129881*^9, 3.5141631448698983`*^9}, {3.5146377055808954`*^9, 
   3.514637744128563*^9}, {3.514637830459114*^9, 3.5146378794900007`*^9}, {
   3.5146382616282716`*^9, 3.5146382652318783`*^9}, {3.514638534605152*^9, 
   3.5146385349171524`*^9}, {3.5151893917052307`*^9, 3.515189414315262*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"B", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "^", "2"}], "-", 
      RowBox[{"1", "/", "4"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, {3.510509139453631*^9, 
   3.5105091408108335`*^9}, {3.5105091901069202`*^9, 3.510509235112999*^9}, {
   3.510511179341214*^9, 3.5105111819776187`*^9}, {3.510511213442874*^9, 
   3.5105112341129103`*^9}, 3.5105113311138806`*^9, {3.5105118645592175`*^9, 
   3.5105118933724685`*^9}, 3.510604217243392*^9, {3.5106043604360437`*^9, 
   3.5106043628072476`*^9}, {3.510604536747553*^9, 3.510604543455565*^9}, {
   3.5106047214206777`*^9, 3.510604766535957*^9}, {3.51060501329719*^9, 
   3.51060503037922*^9}, {3.510607290960391*^9, 3.5106073089160223`*^9}, {
   3.514637808790676*^9, 3.51463781641909*^9}, {3.514638292641126*^9, 
   3.514638313108362*^9}, {3.514638368301259*^9, 3.514638422417754*^9}, {
   3.5146386454277463`*^9, 3.5146386460049477`*^9}, {3.51465546327145*^9, 
   3.514655464441452*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "^", "2"}], "-", 
      RowBox[{"1", "/", "4"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, {3.510509139453631*^9, 
   3.5105091408108335`*^9}, {3.5105091901069202`*^9, 3.510509235112999*^9}, {
   3.510511179341214*^9, 3.5105111819776187`*^9}, {3.510511213442874*^9, 
   3.5105112341129103`*^9}, 3.5105113311138806`*^9, {3.5105118645592175`*^9, 
   3.5105118933724685`*^9}, 3.510604217243392*^9, {3.5106043604360437`*^9, 
   3.5106043628072476`*^9}, {3.510604536747553*^9, 3.510604543455565*^9}, {
   3.5106047214206777`*^9, 3.510604766535957*^9}, {3.51060501329719*^9, 
   3.51060503037922*^9}, {3.510607290960391*^9, 3.5106073089160223`*^9}, {
   3.514637808790676*^9, 3.51463781641909*^9}, {3.514638292641126*^9, 
   3.514638313108362*^9}, {3.514638368301259*^9, 3.514638422417754*^9}, {
   3.5146386454277463`*^9, 3.5146386460049477`*^9}, {3.5146386771114025`*^9, 
   3.514638684396615*^9}, {3.514655467431456*^9, 3.5146554690314584`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.5142509244845037`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      SqrtBox[
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "+", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5105110545409946`*^9, 3.510511103852681*^9}, {
   3.51051176345304*^9, 3.5105117985999017`*^9}, {3.514225818926944*^9, 
   3.5142258276317596`*^9}, {3.514252290556416*^9, 3.5142522978164263`*^9}, 
   3.5148521538637085`*^9, {3.5151894212852716`*^9, 3.515189436345293*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"B", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}]}], ",", "x"}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, {3.510509139453631*^9, 
   3.5105091408108335`*^9}, {3.5105091901069202`*^9, 3.510509235112999*^9}, {
   3.510511179341214*^9, 3.5105111819776187`*^9}, {3.510511213442874*^9, 
   3.5105112341129103`*^9}, 3.5105113311138806`*^9, {3.5105118645592175`*^9, 
   3.5105118933724685`*^9}, 3.510604217243392*^9, 3.5114928751438036`*^9, 
   3.5118133400865397`*^9, 3.513623825580286*^9, 3.514222570580039*^9, 
   3.5142259816508303`*^9, {3.5142504695638666`*^9, 3.514250473293872*^9}, {
   3.514252198616287*^9, 3.5142522024962926`*^9}, {3.5142523180164547`*^9, 
   3.514252341686487*^9}, 3.5146372661901226`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}]}], ",", "x"}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, {3.510509139453631*^9, 
   3.5105091408108335`*^9}, {3.5105091901069202`*^9, 3.510509235112999*^9}, {
   3.510511179341214*^9, 3.5105111819776187`*^9}, {3.510511213442874*^9, 
   3.5105112341129103`*^9}, 3.5105113311138806`*^9, 3.5106042015341644`*^9, 
   3.511492480303251*^9, 3.5118132129063616`*^9, 3.5136240457746725`*^9, 
   3.514222574012045*^9, 3.514225986783239*^9, {3.514250475263874*^9, 
   3.5142504793038797`*^9}, {3.514252204276295*^9, 3.514252207006299*^9}, 
   3.5142523548565063`*^9, 3.514637262976517*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, {
   3.5120748195044174`*^9, 3.5120748357644405`*^9}, 3.514641587297715*^9, {
   3.515189444375304*^9, 3.5151894460053062`*^9}, {3.516563932687272*^9, 
   3.5165639351572757`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.5043197795435286`*^9, 
   3.50431978625154*^9}, 3.504319919709775*^9, {3.504322280699083*^9, 
   3.504322284869088*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "C"}], "-", 
    RowBox[{"a", " ", "b", " ", "B"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], "A"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"A", "+", 
    RowBox[{"B", " ", "z"}], "+", 
    RowBox[{"C", " ", 
     SuperscriptBox["z", "2"]}]}], "=", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["b", "2"]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "B"}], "-", 
      RowBox[{"a", " ", "C"}], "+", 
      RowBox[{"b", " ", "C", " ", "z"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}], ")"}]}]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
    3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
    3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
    3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
    3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
    3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
    3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
    3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
    3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
    3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
    3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
    3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
    3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
    3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
    3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
    3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
    3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
    3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
    3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
    3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
    3.500317979417313*^9}, 3.500318137887991*^9, {3.500320987496489*^9, 
    3.5003209877464895`*^9}, 3.500321038956561*^9, {3.500321320996956*^9, 
    3.5003213249969616`*^9}, {3.5003434983662286`*^9, 3.500343500326231*^9}, {
    3.5003436423664303`*^9, 3.5003436444664335`*^9}, {3.5003436824264865`*^9, 
    3.5003436848164897`*^9}, {3.5003439229068227`*^9, 3.500343939856847*^9}, {
    3.5003440047469378`*^9, 3.5003440064569397`*^9}, {3.5003449676282854`*^9, 
    3.500345050288401*^9}, {3.50041058132454*^9, 3.5004105965114083`*^9}, {
    3.500410650539499*^9, 3.500410712405037*^9}, {3.501042516575889*^9, 
    3.5010425566851835`*^9}, {3.50173055303666*^9, 3.5017305562814665`*^9}, {
    3.503422112988663*^9, 3.503422262028872*^9}, {3.503422592859335*^9, 
    3.503422600339346*^9}, {3.504316193046645*^9, 3.5043163020867977`*^9}, {
    3.504316347226861*^9, 3.5043163474068613`*^9}, {3.504316621257245*^9, 
    3.5043166680273104`*^9}, {3.5043167748874598`*^9, 
    3.5043168530275693`*^9}, {3.5043168840276127`*^9, 
    3.5043169030276394`*^9}, {3.5043169888177595`*^9, 
    3.5043169943277674`*^9}, {3.504317029867817*^9, 3.504317036217826*^9}, {
    3.50431706777787*^9, 3.5043170701878734`*^9}, 3.5043173626582828`*^9, {
    3.5043174181083603`*^9, 3.5043174386883893`*^9}, {3.504320000689517*^9, 
    3.5043200095503325`*^9}, {3.5043200496112027`*^9, 3.5043200928388786`*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.5043197795435286`*^9, 
   3.50431978625154*^9}, 3.504319919709775*^9, {3.504322280699083*^9, 
   3.504322284869088*^9}, {3.504322456729329*^9, 3.504322486479371*^9}, {
   3.504322519719417*^9, 3.504322531389434*^9}, {3.504322606779539*^9, 
   3.5043226386395836`*^9}, {3.504323125022704*^9, 3.504323127269108*^9}, {
   3.5043260526646476`*^9, 3.5043260789974937`*^9}, 3.5043261664356475`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], "A"}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{"1", " "}], 
      SuperscriptBox["b", "2"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B"}], "-", 
       RowBox[{"a", " ", "C"}], "+", 
       RowBox[{"b", " ", "C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.500320987496489*^9, 
   3.5003209877464895`*^9}, 3.500321038956561*^9, {3.500321320996956*^9, 
   3.5003213249969616`*^9}, {3.5003434983662286`*^9, 3.500343500326231*^9}, {
   3.5003436423664303`*^9, 3.5003436444664335`*^9}, {3.5003436824264865`*^9, 
   3.5003436848164897`*^9}, {3.5003439229068227`*^9, 3.500343939856847*^9}, {
   3.5003440047469378`*^9, 3.5003440064569397`*^9}, {3.5003449676282854`*^9, 
   3.500345050288401*^9}, {3.50041058132454*^9, 3.5004105965114083`*^9}, {
   3.500410650539499*^9, 3.500410712405037*^9}, {3.501042516575889*^9, 
   3.5010425566851835`*^9}, {3.50173055303666*^9, 3.5017305562814665`*^9}, {
   3.503422112988663*^9, 3.503422262028872*^9}, {3.503422592859335*^9, 
   3.503422600339346*^9}, {3.504316193046645*^9, 3.5043163020867977`*^9}, {
   3.504316347226861*^9, 3.5043163474068613`*^9}, {3.504316621257245*^9, 
   3.5043166680273104`*^9}, {3.5043167748874598`*^9, 
   3.5043168530275693`*^9}, {3.5043168840276127`*^9, 
   3.5043169030276394`*^9}, {3.5043169888177595`*^9, 
   3.5043169943277674`*^9}, {3.504317029867817*^9, 3.504317036217826*^9}, {
   3.50431706777787*^9, 3.5043170701878734`*^9}, 3.5043173626582828`*^9, {
   3.5043174181083603`*^9, 3.5043174386883893`*^9}, {3.504320000689517*^9, 
   3.5043200095503325`*^9}, {3.5043200496112027`*^9, 
   3.5043200928388786`*^9}, {3.5043231719631863`*^9, 3.504323184256008*^9}, {
   3.5043232225696754`*^9, 3.5043232285756855`*^9}, 3.5043259535732737`*^9, {
   3.5043266695969486`*^9, 3.504326711857423*^9}, 3.504327136817769*^9, {
   3.505344692743856*^9, 3.505344692743856*^9}, {3.509483732978155*^9, 
   3.509483758783631*^9}, {3.515189446495307*^9, 3.5151894480753098`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", "2"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sim", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "*", "B"}], "-", 
           RowBox[{"a", "*", "C"}], "+", 
           RowBox[{"b", "*", "C", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
         "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, {
   3.5003467181807365`*^9, 3.5003467183807364`*^9}, {3.5003470702912292`*^9, 
   3.500347084191249*^9}, {3.5003473183115764`*^9, 3.5003473372616034`*^9}, {
   3.501042973714036*^9, 3.501042977877274*^9}, {3.5017253080750456`*^9, 
   3.5017253261554775`*^9}, {3.503072366698799*^9, 3.503072386368827*^9}, {
   3.503423484860584*^9, 3.503423487310587*^9}, {3.5043179673075447`*^9, 
   3.504317975591159*^9}, 3.5043181034021835`*^9, 3.5043201551609883`*^9, {
   3.5043202057206774`*^9, 3.5043202282003164`*^9}, {3.504320408505433*^9, 
   3.5043204189730515`*^9}, {3.504323302675816*^9, 3.504323318151043*^9}, 
   3.504323387773965*^9, {3.5043238268211365`*^9, 3.5043238427331643`*^9}, {
   3.5043259906857386`*^9, 3.5043260287342052`*^9}, {3.504326731061056*^9, 
   3.504326753587496*^9}, {3.5043272526791725`*^9, 3.5043272537243743`*^9}, {
   3.504368335278517*^9, 3.504368362788555*^9}, {3.505344692763856*^9, 
   3.505344692773856*^9}, {3.509475757945009*^9, 3.5094757683196025`*^9}, 
   3.5094838141357965`*^9, {3.50948388622692*^9, 3.50948389583947*^9}, 
   3.5098967808695436`*^9, 3.509937966863408*^9, 3.509938090123581*^9, {
   3.5101683428658543`*^9, 3.5101683437394557`*^9}, {3.515979195355174*^9, 
   3.515979196041576*^9}, 3.51682122637726*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"C", "/", 
      RowBox[{"b", "^", "2"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sim", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
         "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, {
   3.5003467181807365`*^9, 3.5003467183807364`*^9}, {3.5003470702912292`*^9, 
   3.500347084191249*^9}, {3.5003473183115764`*^9, 3.5003473372616034`*^9}, {
   3.501042973714036*^9, 3.501042977877274*^9}, {3.5017253080750456`*^9, 
   3.5017253261554775`*^9}, {3.503072366698799*^9, 3.503072386368827*^9}, {
   3.503423484860584*^9, 3.503423487310587*^9}, {3.5043179673075447`*^9, 
   3.504317975591159*^9}, 3.5043181034021835`*^9, 3.5043201551609883`*^9, {
   3.5043202057206774`*^9, 3.5043202282003164`*^9}, {3.504320408505433*^9, 
   3.5043204189730515`*^9}, {3.504323302675816*^9, 3.504323318151043*^9}, 
   3.504323387773965*^9, {3.5043238268211365`*^9, 3.5043238427331643`*^9}, {
   3.5043259906857386`*^9, 3.5043260287342052`*^9}, {3.504326731061056*^9, 
   3.504326753587496*^9}, {3.5043272526791725`*^9, 3.5043272537243743`*^9}, {
   3.504368335278517*^9, 3.504368362788555*^9}, {3.505344692763856*^9, 
   3.505344692773856*^9}, {3.509475757945009*^9, 3.5094757683196025`*^9}, 
   3.5094838141357965`*^9, {3.50948388622692*^9, 3.50948389583947*^9}, {
   3.509500795286421*^9, 3.5095007985780263`*^9}, {3.509500851321719*^9, 
   3.5095008515089197`*^9}, {3.509500961707513*^9, 3.509500975950338*^9}, 
   3.509937959183398*^9, 3.5099380632035437`*^9, {3.510169521000723*^9, 
   3.510169549030772*^9}, 3.5104336417619877`*^9, 3.5168212263972597`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "17"}], "-", "18"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, {
   3.5120748195044174`*^9, 3.5120748357644405`*^9}, 3.514641587297715*^9, {
   3.515189444375304*^9, 3.5151894460053062`*^9}, 3.5165635938067975`*^9, {
   3.516590021628518*^9, 3.5165900239885216`*^9}, {3.5165909760698547`*^9, 
   3.5165909779798574`*^9}, {3.516591625170763*^9, 3.5165916281107674`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 6 with",
 " ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.5056772028204613`*^9, 
   3.5056772028204613`*^9}, {3.505705966225328*^9, 3.505705969135332*^9}, {
   3.5057080117296715`*^9, 3.5057080125252724`*^9}, {3.509482067290883*^9, 
   3.509482067608901*^9}, {3.509482121056958*^9, 3.5094821279613533`*^9}, 
   3.512074591844099*^9, 3.5141617833779926`*^9, 3.5146489361255713`*^9, 
   3.514648982005252*^9}],

Cell[TextData[{
 "Rule 17: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "C"}], "-", 
     RowBox[{"a", " ", "b", " ", "B"}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "A"}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.501358653573163*^9, 3.5013586559531665`*^9}, {
   3.502678432393256*^9, 3.5026784351732597`*^9}, {3.5027657117315207`*^9, 
   3.5027657146955256`*^9}, {3.5027672159617634`*^9, 
   3.5027672159617634`*^9}, {3.503549413750845*^9, 3.5035494378508787`*^9}, {
   3.5040286533797517`*^9, 3.5040286542689533`*^9}, 3.504031878337816*^9, 
   3.5043107701173162`*^9, {3.509475086194587*^9, 3.509475086194587*^9}, {
   3.509482394790615*^9, 3.50948240170201*^9}, {3.509482441473285*^9, 
   3.509482442830363*^9}, {3.509936150088864*^9, 3.5099361505888643`*^9}, {
   3.510505178105473*^9, 3.5105051785266733`*^9}, {3.5146149116537275`*^9, 
   3.5146149132957306`*^9}, {3.514660109737955*^9, 3.5146601100279555`*^9}, 
   3.516563830387129*^9, {3.516590031478532*^9, 3.516590031698532*^9}, {
   3.5165916432507887`*^9, 3.5165916438207893`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C"}], "-", 
          RowBox[{"a", " ", "b", " ", "B"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}], "+", 
          RowBox[{"b", " ", "C"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C"}], "-", 
          RowBox[{"a", " ", "b", " ", "B"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.5094821535608177`*^9, 3.509482269330439*^9}, {3.5094823193803015`*^9, 
   3.509482343956708*^9}, {3.515189482685358*^9, 3.5151895017753844`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
       RowBox[{"a", "*", "b", "*", "B"}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "-", 
               RowBox[{"b", "^", "2"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"b", "*", "A"}], "-", 
                 RowBox[{"a", "*", "B"}], "+", 
                 RowBox[{"b", "*", "C"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}], "+", "\n", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
               RowBox[{"a", "*", "b", "*", "B"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, 
   3.50052634660607*^9, {3.501043281866661*^9, 3.5010432838407745`*^9}, {
   3.501358610383103*^9, 3.5013586217531185`*^9}, {3.5026774770619183`*^9, 
   3.5026774832519274`*^9}, {3.502677757052311*^9, 3.502677762832319*^9}, {
   3.5027656424673986`*^9, 3.502765645119404*^9}, {3.502767123656401*^9, 
   3.502767137805626*^9}, {3.5030718732081084`*^9, 3.503071876548113*^9}, {
   3.503072001488288*^9, 3.5030720017582884`*^9}, {3.5035493869908075`*^9, 
   3.503549399840825*^9}, 3.503555712201664*^9, {3.5051555554059405`*^9, 
   3.5051555560359416`*^9}, {3.5053446414837847`*^9, 3.505344668463822*^9}, 
   3.505344708453878*^9, 3.50535356428522*^9, {3.509474964753641*^9, 
   3.509474975710268*^9}, 3.5094750696026382`*^9, 3.509475101121441*^9, {
   3.509482557719934*^9, 3.5094825578999443`*^9}, {3.5094826279499507`*^9, 
   3.50948265957976*^9}, {3.509482763987732*^9, 3.5094828063561554`*^9}, 
   3.509896697393797*^9, 3.5099098514350123`*^9, 3.5150157958115206`*^9, {
   3.5150158636634016`*^9, 3.5150158753280687`*^9}, {3.515979264365296*^9, 
   3.515979273444512*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "-", 
               RowBox[{"b", "^", "2"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "*", "b", "*", 
               RowBox[{"(", 
                RowBox[{"A", "+", "C"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, 
   3.50052634660607*^9, {3.501043281866661*^9, 3.5010432838407745`*^9}, {
   3.501358610383103*^9, 3.5013586217531185`*^9}, {3.5026774770619183`*^9, 
   3.5026774832519274`*^9}, {3.502677757052311*^9, 3.502677762832319*^9}, {
   3.5027656424673986`*^9, 3.502765645119404*^9}, {3.502767123656401*^9, 
   3.502767137805626*^9}, {3.5030718732081084`*^9, 3.503071876548113*^9}, {
   3.503072001488288*^9, 3.5030720017582884`*^9}, {3.5035493869908075`*^9, 
   3.503549399840825*^9}, 3.503555712201664*^9, {3.5051555554059405`*^9, 
   3.5051555560359416`*^9}, {3.5053446414837847`*^9, 3.505344668463822*^9}, 
   3.505344708453878*^9, 3.50535356428522*^9, {3.509474964753641*^9, 
   3.509474975710268*^9}, 3.5094750696026382`*^9, 3.509475101121441*^9, {
   3.509482557719934*^9, 3.5094825578999443`*^9}, {3.5094826279499507`*^9, 
   3.50948265957976*^9}, {3.509482763987732*^9, 3.5094828063561554`*^9}, {
   3.5095008993074036`*^9, 3.509500902567809*^9}, {3.509501105274565*^9, 
   3.509501146068637*^9}, 3.5099029321630383`*^9, 3.5104336431119895`*^9, 
   3.5105036526255937`*^9, 3.5105517686228065`*^9, 3.5150158033989544`*^9, {
   3.5150158783112392`*^9, 3.51501588006234*^9}, {3.515979303100164*^9, 
   3.515979305330968*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3 with",
 " ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.5017304653801064`*^9, 3.501730494037357*^9}, {3.501730604179551*^9, 
   3.5017306171587734`*^9}, {3.5034185653536963`*^9, 
   3.5034185683937006`*^9}, {3.5034226237593784`*^9, 3.5034226290093856`*^9}, 
   3.5053451044944324`*^9, {3.509482100959809*^9, 3.509482110306343*^9}, {
   3.509483028748875*^9, 3.5094830290958953`*^9}, 3.5094830598816557`*^9, 
   3.512074560134054*^9, 3.5141617863379965`*^9, 3.5146489562652063`*^9, 
   3.5146489938924727`*^9}],

Cell[TextData[{
 "Note: If  ",
 Cell[BoxData[
  RowBox[{"A", "=", 
   RowBox[{"B", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "=", "0"}]}]}]]],
 ", there is an ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 " rule that simplifies resulting integrand to ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]]],
 "."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4993685152127995`*^9, 3.499368525272814*^9}, {3.5003196739046497`*^9, 
   3.5003196775646553`*^9}, {3.5004320218638687`*^9, 
   3.5004320229179287`*^9}, {3.5026773276717095`*^9, 
   3.5026773598217545`*^9}, {3.5027672801246758`*^9, 
   3.5027672801246758`*^9}, {3.5040286397141275`*^9, 
   3.5040286407749295`*^9}, {3.5040290157527885`*^9, 3.5040290170787907`*^9}, 
   3.5040318675893974`*^9, {3.504296981415786*^9, 3.5042969896257973`*^9}, 
   3.5043107563112917`*^9, {3.5047476042825956`*^9, 3.5047476056225977`*^9}, {
   3.5051011018466954`*^9, 3.5051011152867146`*^9}, {3.5094725039578915`*^9, 
   3.5094725039578915`*^9}, {3.509482967894395*^9, 3.5094829685864344`*^9}, {
   3.509483013292991*^9, 3.50948301380202*^9}, {3.5094836096611013`*^9, 
   3.509483623031866*^9}, {3.509933349374943*^9, 3.509933351224945*^9}, {
   3.5099361601988783`*^9, 3.509936163688883*^9}, {3.5105051874030895`*^9, 
   3.5105051880582905`*^9}, {3.5146149781762447`*^9, 3.514614979939048*^9}, {
   3.514648240317549*^9, 3.5146482411911507`*^9}, {3.5150181788158207`*^9, 
   3.5150182348360248`*^9}, {3.515018280347628*^9, 3.5150183576910515`*^9}, {
   3.515018445815092*^9, 3.5150185137259765`*^9}, {3.515018545413789*^9, 
   3.515018641954311*^9}, {3.5150208095912924`*^9, 3.5150208097863035`*^9}, {
   3.515189557965463*^9, 3.515189557965463*^9}}],

Cell[TextData[{
 "Rule 18: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"A", "=", 
      RowBox[{"B", "=", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], "=", "0"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4993685152127995`*^9, 3.499368525272814*^9}, {3.5003196739046497`*^9, 
   3.5003196775646553`*^9}, {3.5004320218638687`*^9, 
   3.5004320229179287`*^9}, {3.5026773276717095`*^9, 
   3.5026773598217545`*^9}, {3.5027672801246758`*^9, 
   3.5027672801246758`*^9}, {3.5040286397141275`*^9, 
   3.5040286407749295`*^9}, {3.5040290157527885`*^9, 3.5040290170787907`*^9}, 
   3.5040318675893974`*^9, {3.504296981415786*^9, 3.5042969896257973`*^9}, 
   3.5043107563112917`*^9, {3.5047476042825956`*^9, 3.5047476056225977`*^9}, {
   3.5051011018466954`*^9, 3.5051011152867146`*^9}, {3.5094725039578915`*^9, 
   3.5094725039578915`*^9}, {3.509482967894395*^9, 3.5094829685864344`*^9}, {
   3.509483013292991*^9, 3.50948301380202*^9}, {3.5094836096611013`*^9, 
   3.509483623031866*^9}, {3.509933349374943*^9, 3.509933351224945*^9}, {
   3.5099361601988783`*^9, 3.509936163688883*^9}, {3.5105051874030895`*^9, 
   3.5105051880582905`*^9}, {3.5146149781762447`*^9, 3.514614979939048*^9}, {
   3.514648240317549*^9, 3.5146482411911507`*^9}, {3.5150181788158207`*^9, 
   3.5150182348360248`*^9}, {3.515018280347628*^9, 3.515018298440663*^9}, 
   3.516563833817134*^9, {3.5165900346485367`*^9, 3.516590034918537*^9}, {
   3.5165916467507935`*^9, 3.5165916489207964`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"n", "+", "1"}]], "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "+", 
          RowBox[{"a", " ", "B"}], "+", 
          RowBox[{"n", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "A"}], "+", 
             RowBox[{"a", " ", "B"}], "+", 
             RowBox[{"b", " ", "C"}]}], ")"}]}]}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "C", " ", "n"}], "+", 
          RowBox[{"b", " ", "B", " ", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5094830441507564`*^9, 3.5094831917952013`*^9}, {3.5094833027715483`*^9, 
   3.509483305747719*^9}, {3.509483389621516*^9, 3.5094834110637426`*^9}, {
   3.514648395194621*^9, 3.5146484026202345`*^9}, {3.515189562205469*^9, 
   3.515189579115493*^9}, {3.516563628316846*^9, 3.516563656826886*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{"a", "*", "B"}], "+", 
               RowBox[{"n", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}], "+", 
                  RowBox[{"b", "*", "C"}]}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "C", "*", "n"}], "+", 
               RowBox[{"b", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.509483206773058*^9, 3.509483232269516*^9}, {3.509483529175498*^9, 
   3.509483565841595*^9}, {3.5094836038257675`*^9, 3.509483605101841*^9}, 
   3.5098965677731695`*^9, {3.509933338924928*^9, 3.509933341554932*^9}, 
   3.5118134624967113`*^9, 3.514403013977007*^9, 3.514648425505474*^9, 
   3.5150158047580323`*^9, {3.5150158819504476`*^9, 3.5150158838375554`*^9}, {
   3.515979370799883*^9, 3.515979372406686*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", 
               RowBox[{"n", "*", 
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}], "+", 
            RowBox[{"a", "*", "C", "*", "n", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "2"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", "\n", 
         "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", "A", "]"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.509483206773058*^9, 3.509483232269516*^9}, {3.509483529175498*^9, 
   3.509483565841595*^9}, {3.5094836038257675`*^9, 3.509483605101841*^9}, {
   3.5095009240490465`*^9, 3.5095009272782526`*^9}, {3.5095012643168445`*^9, 
   3.5095013143617325`*^9}, 3.5099029224730244`*^9, {3.5099334141350336`*^9, 
   3.5099334155450354`*^9}, 3.5104336477619963`*^9, 3.510551779322821*^9, 
   3.511813228736384*^9, 3.514403046040841*^9, 3.5146484319950857`*^9, 
   3.515015806396126*^9, {3.5150158877017765`*^9, 3.5150158893328695`*^9}, {
   3.5150159610809736`*^9, 3.5150159896686087`*^9}, {3.5159793832955046`*^9, 
   3.5159793848243074`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "15"}], "-", "16"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, {
   3.5120748195044174`*^9, 3.5120748357644405`*^9}, 3.514641587297715*^9, {
   3.515189444375304*^9, 3.5151894460053062`*^9}, {3.5165632243662806`*^9, 
   3.516563224686281*^9}, {3.5165632985363846`*^9, 3.5165633012463884`*^9}, {
   3.5165900432885485`*^9, 3.5165900449585505`*^9}, {3.51659097998986*^9, 
   3.5165909811798615`*^9}, {3.516591621550758*^9, 3.516591623660761*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: For ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]],
 ", Rule 9b with ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.505345104484432*^9, 
   3.505345123354459*^9}, {3.5057058835492005`*^9, 3.5057058890792084`*^9}, {
   3.5094820888781176`*^9, 3.5094820947444534`*^9}, 3.5120745389640245`*^9, 
   3.514161770227974*^9, 3.51464892969836*^9, {3.514659985007781*^9, 
   3.514659985377781*^9}, {3.5146604663184547`*^9, 3.5146604884584856`*^9}}],

Cell[TextData[{
 "Derivation: For ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 ", ???"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.505345104484432*^9, 
   3.505345123354459*^9}, {3.5057058835492005`*^9, 3.5057058890792084`*^9}, {
   3.5094820888781176`*^9, 3.5094820947444534`*^9}, 3.5120745389640245`*^9, 
   3.514161770227974*^9, 3.51464892969836*^9, {3.514659985007781*^9, 
   3.514659985377781*^9}, {3.514660492108491*^9, 3.514660501378504*^9}}],

Cell[TextData[{
 "Rule 15: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.5004322533111067`*^9, 
   3.5004322794606023`*^9}, {3.5030203943207865`*^9, 
   3.5030203943207865`*^9}, {3.5043646078512945`*^9, 3.504364638711338*^9}, 
   3.504471249250667*^9, {3.504983297263383*^9, 3.504983298043384*^9}, {
   3.505185059347052*^9, 3.5051850634142847`*^9}, {3.510010655210175*^9, 
   3.510010661460184*^9}, {3.5105052330331697`*^9, 3.510505233813171*^9}, {
   3.512186750070178*^9, 3.51218675138058*^9}, {3.512254288430264*^9, 
   3.512254290224267*^9}, 3.5122690611683536`*^9, {3.5130527066400003`*^9, 
   3.5130527081400023`*^9}, {3.5146068262688007`*^9, 
   3.5146068262688007`*^9}, {3.5146069044289103`*^9, 3.51460695440898*^9}, {
   3.5146437381652417`*^9, 3.5146437387112427`*^9}, {3.514648236745143*^9, 
   3.5146482370727434`*^9}, {3.514648812807355*^9, 3.5146488252093763`*^9}, {
   3.5146529401479177`*^9, 3.5146529409379187`*^9}, {3.51466005590788*^9, 
   3.514660068307897*^9}, {3.514660102007944*^9, 3.5146601233979745`*^9}, {
   3.516563313966406*^9, 3.5165633145464067`*^9}, {3.516590048018555*^9, 
   3.5165900483485556`*^9}, {3.5165916325107737`*^9, 3.516591632990774*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", "A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}], " ", "B"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "A"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"A", "+", " ", "C"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, {3.5094801431328278`*^9, 
   3.5094801751356583`*^9}, {3.5094802246834917`*^9, 
   3.5094802301888065`*^9}, {3.509480713400445*^9, 3.509480768723609*^9}, {
   3.5094808269999423`*^9, 3.5094808723875384`*^9}, {3.5094809372162466`*^9, 
   3.509480949923973*^9}, {3.51465880586613*^9, 3.5146588801362343`*^9}, {
   3.51465891322628*^9, 3.5146589462863264`*^9}, {3.514658986056382*^9, 
   3.5146589924163914`*^9}, {3.5146590248564367`*^9, 3.514659051186473*^9}, {
   3.51465918482666*^9, 3.5146592563867607`*^9}, 3.5146592919368105`*^9, {
   3.51465934869689*^9, 3.514659401466964*^9}, {3.514659463667051*^9, 
   3.5146594829870777`*^9}, {3.5146595199871297`*^9, 
   3.5146595377171545`*^9}, {3.515189456155321*^9, 3.515189459655326*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}], "*", 
             "B"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.514659704917389*^9, {3.5146598558375998`*^9, 
   3.514659887987645*^9}, {3.5146599406877184`*^9, 3.5146599625077496`*^9}, {
   3.5146599993978004`*^9, 3.514660023607835*^9}, 3.5146613782197313`*^9, 
   3.5168212265172606`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "A"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"A", "+", "C"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}]}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}], 
      ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.514659704917389*^9, {3.5146598558375998`*^9, 
   3.514659887987645*^9}, {3.5146599406877184`*^9, 3.5146599625077496`*^9}, {
   3.5146599993978004`*^9, 3.514660023607835*^9}, {3.514660185568062*^9, 
   3.514660242228141*^9}, {3.5146603284282618`*^9, 3.5146603355682716`*^9}, {
   3.514660367128316*^9, 3.514660379908334*^9}, 3.5168212265472603`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 2 or 3 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.5017264195673985`*^9, 
   3.5017264509546537`*^9}, {3.5017265299999924`*^9, 3.5017265322151966`*^9}, 
   3.505345123284459*^9, 3.512064236782365*^9, {3.5141593635446043`*^9, 
   3.5141594128246737`*^9}, {3.514605571897044*^9, 3.514605574277048*^9}, {
   3.514607455309681*^9, 3.5146074574796844`*^9}, {3.514643728805225*^9, 
   3.5146437302092276`*^9}, {3.5146482454343576`*^9, 3.514648258616381*^9}, {
   3.514653015378023*^9, 3.514653114608162*^9}}],

Cell[TextData[{
 "Rule 16: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.5004322533111067`*^9, 
   3.5004322794606023`*^9}, {3.5030203943207865`*^9, 
   3.5030203943207865`*^9}, {3.5043646078512945`*^9, 3.504364638711338*^9}, 
   3.504471249250667*^9, {3.504983297263383*^9, 3.504983298043384*^9}, {
   3.505185059347052*^9, 3.5051850634142847`*^9}, {3.510010655210175*^9, 
   3.510010661460184*^9}, {3.5105052330331697`*^9, 3.510505233813171*^9}, {
   3.512186750070178*^9, 3.51218675138058*^9}, {3.512254288430264*^9, 
   3.512254290224267*^9}, 3.5122690611683536`*^9, {3.5130527066400003`*^9, 
   3.5130527081400023`*^9}, {3.5146068262688007`*^9, 
   3.5146068262688007`*^9}, {3.5146069044289103`*^9, 3.51460695440898*^9}, {
   3.5146437381652417`*^9, 3.5146437387112427`*^9}, {3.514648236745143*^9, 
   3.5146482370727434`*^9}, {3.514648812807355*^9, 3.5146488252093763`*^9}, {
   3.5146529401479177`*^9, 3.5146529409379187`*^9}, {3.51466005590788*^9, 
   3.514660068307897*^9}, {3.51656331676641*^9, 3.516563317446411*^9}, {
   3.51659005157856*^9, 3.516590052038561*^9}, {3.516591635280777*^9, 
   3.5165916360507784`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "k", "+", "3"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "A"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", "C"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}], "+", 
       RowBox[{"B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5101642321454153`*^9, 3.5101642363106227`*^9}, {
   3.5101642797722993`*^9, 3.5101643150283613`*^9}, {3.5101646049236703`*^9, 
   3.5101646129576845`*^9}, {3.514653175878248*^9, 3.5146532696083794`*^9}, {
   3.5146534363086123`*^9, 3.5146535572687817`*^9}, {3.5146535896388273`*^9, 
   3.5146536161488647`*^9}, {3.514653750049052*^9, 3.514653750269052*^9}, {
   3.5151895226554136`*^9, 3.515189524475416*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "C", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "*", "A"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], "+", 
            RowBox[{"B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4979862253061905`*^9, {
   3.497986271107871*^9, 3.497986297799518*^9}, 3.497986386903675*^9, 
   3.4986794582767816`*^9, {3.500419863725463*^9, 3.5004198652605505`*^9}, 
   3.5004202566819386`*^9, {3.500432258158384*^9, 3.5004322592084436`*^9}, 
   3.503020185000493*^9, 3.503020369830752*^9, {3.5030725476090527`*^9, 
   3.5030725694590836`*^9}, 3.503876142483889*^9, {3.505185046002289*^9, 
   3.5051850551548123`*^9}, 3.505344640573783*^9, {3.5053446907338533`*^9, 
   3.505344714193886*^9}, 3.505352025233065*^9, 3.5087829424446387`*^9, {
   3.509895272053728*^9, 3.509895275953734*^9}, 3.510433804704217*^9, 
   3.510513659779171*^9, 3.511807932152954*^9, {3.5121872577122717`*^9, 
   3.512187260473477*^9}, {3.5122693811788015`*^9, 3.5122693823488035`*^9}, 
   3.5130467260581713`*^9, 3.5130480309114447`*^9, {3.5144150721536956`*^9, 
   3.514415073159753*^9}, 3.5144740613848653`*^9, {3.5146064392882586`*^9, 
   3.5146064403682604`*^9}, {3.5146065012883453`*^9, 3.5146065378183966`*^9}, 
   3.51460656896844*^9, {3.514606696748619*^9, 3.514606787928747*^9}, {
   3.51461276128675*^9, 3.514612763049553*^9}, 3.514643840345421*^9, 
   3.514643872949478*^9, {3.514648577855342*^9, 3.514648626465027*^9}, 
   3.5146486618146896`*^9, {3.5146488319953885`*^9, 3.514648832572589*^9}, {
   3.514649903810871*^9, 3.514649906369275*^9}, {3.514649981405407*^9, 
   3.514649983542611*^9}, {3.514653889439247*^9, 3.5146539654093533`*^9}, 
   3.5168212265772605`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "C", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "A"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"A", "+", "C"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}]}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         "n"}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4979862253061905`*^9, {
   3.497986271107871*^9, 3.497986297799518*^9}, 3.497986386903675*^9, 
   3.4986794582767816`*^9, {3.500419863725463*^9, 3.5004198652605505`*^9}, 
   3.5004202566819386`*^9, {3.500432258158384*^9, 3.5004322592084436`*^9}, 
   3.503020185000493*^9, 3.503020369830752*^9, {3.5030725476090527`*^9, 
   3.5030725694590836`*^9}, 3.503876142483889*^9, {3.505185046002289*^9, 
   3.5051850551548123`*^9}, 3.505344640573783*^9, {3.5053446907338533`*^9, 
   3.505344714193886*^9}, 3.505352025233065*^9, 3.5087829424446387`*^9, {
   3.509895272053728*^9, 3.509895275953734*^9}, 3.510433804704217*^9, 
   3.510513659779171*^9, 3.511807932152954*^9, {3.5121872577122717`*^9, 
   3.512187260473477*^9}, {3.5122693811788015`*^9, 3.5122693823488035`*^9}, 
   3.5130467260581713`*^9, 3.5130480309114447`*^9, {3.5144150721536956`*^9, 
   3.514415073159753*^9}, 3.5144740613848653`*^9, {3.5146064392882586`*^9, 
   3.5146064403682604`*^9}, {3.5146065012883453`*^9, 3.5146065378183966`*^9}, 
   3.51460656896844*^9, {3.514606696748619*^9, 3.514606787928747*^9}, {
   3.51461276128675*^9, 3.514612763049553*^9}, 3.514643840345421*^9, 
   3.514643872949478*^9, {3.514648577855342*^9, 3.514648626465027*^9}, 
   3.5146486618146896`*^9, {3.5146488319953885`*^9, 3.514648832572589*^9}, {
   3.514649903810871*^9, 3.514649906369275*^9}, {3.514649981405407*^9, 
   3.514649983542611*^9}, {3.514653889439247*^9, 3.5146539654093533`*^9}, {
   3.514654007989413*^9, 3.5146540510894732`*^9}, {3.5146540834295187`*^9, 
   3.5146540836195188`*^9}, 3.5146614087797737`*^9, 3.5168212265972605`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5148547622870913`*^9, 3.5148547622870913`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["b",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.508615440708002*^9, 3.5086154744040613`*^9, {3.5086155092857227`*^9, 
   3.508615515681734*^9}, 3.5087287410392494`*^9, {3.508784051294586*^9, 
   3.5087840520589876`*^9}, {3.5095529155176115`*^9, 
   3.5095529177172155`*^9}, {3.51058502262803*^9, 3.510585070278096*^9}, {
   3.5105851211181674`*^9, 3.5105851328781843`*^9}, 3.511973864619875*^9, {
   3.5120747294242916`*^9, 3.5120747295942917`*^9}, {3.5146417557000113`*^9, 
   3.514641756620413*^9}, 3.514854245068183*^9, {3.5151896201555505`*^9, 
   3.515189621025552*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}, {
   3.5010281936486645`*^9, 3.501028196142807*^9}, {3.5105845295473394`*^9, 
   3.5105845315073423`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox["z", "2"]}]}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["A", 
     RowBox[{"a", " ", "z"}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}], "-", 
      RowBox[{"a", " ", "C", " ", "z"}]}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.5006681103278956`*^9, 3.500668167617976*^9}, {
   3.5006682214480515`*^9, 3.500668278938132*^9}, {3.500668429098342*^9, 
   3.5006684314183455`*^9}, {3.5007438770458975`*^9, 3.500743899705929*^9}, {
   3.5007439773260374`*^9, 3.5007440143660893`*^9}, {3.500744077676178*^9, 
   3.5007440802161818`*^9}, {3.508781140228789*^9, 3.5087811407387896`*^9}, {
   3.5087812197089005`*^9, 3.5087812205389013`*^9}, {3.510585830679161*^9, 
   3.510585864979209*^9}, {3.510585971999359*^9, 3.5105859925093875`*^9}, {
   3.510586053639473*^9, 3.5105860774895067`*^9}}],

Cell[TextData[{
 "Rule b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, 3.500401902143732*^9, {
   3.5004019322673855`*^9, 3.5004019348725896`*^9}, {3.500431975630224*^9, 
   3.500431976700285*^9}, {3.500596487572508*^9, 3.5005964955909224`*^9}, {
   3.5005976481165457`*^9, 3.50059769596183*^9}, {3.50059778134078*^9, 
   3.5005977822611814`*^9}, 3.500603436159915*^9, {3.500752664340207*^9, 
   3.5007526883602405`*^9}, 3.500754770973156*^9, {3.5047492657049217`*^9, 
   3.5047492671549234`*^9}, 3.5047502899163556`*^9, 3.504764229948123*^9, 
   3.5105851536882133`*^9, 3.5119738316979923`*^9, {3.5148542476889877`*^9, 
   3.5148542483129883`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["A", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}], "-", 
       RowBox[{"a", " ", "C", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5004019027833333`*^9, 3.5004019090077443`*^9}, {3.5004019461670094`*^9, 
   3.5004019604098344`*^9}, {3.5004020022023077`*^9, 
   3.5004020999052796`*^9}, {3.500403170537961*^9, 3.5004031709747615`*^9}, {
   3.5004032188980455`*^9, 3.500403243093688*^9}, {3.500596131704683*^9, 
   3.5005961322818837`*^9}, {3.500596573684659*^9, 3.50059658569668*^9}, {
   3.500596750360569*^9, 3.500596757676982*^9}, {3.5005968433423324`*^9, 
   3.500596857273157*^9}, {3.5005972743710895`*^9, 3.5005972953687263`*^9}, {
   3.5005986514683084`*^9, 3.5005986952419853`*^9}, {3.500598795206961*^9, 
   3.5005987969385643`*^9}, {3.5005989433292212`*^9, 
   3.5005989622364545`*^9}, {3.500691131426506*^9, 3.5006911595265455`*^9}, {
   3.500698437682624*^9, 3.5006985085691485`*^9}, {3.5006991256250324`*^9, 
   3.5006991261554337`*^9}, {3.500699909510809*^9, 3.5006999123968143`*^9}, {
   3.5007476294511504`*^9, 3.500747637191161*^9}, {3.500747709211262*^9, 
   3.500747734041297*^9}, {3.500749692956047*^9, 3.500749800106197*^9}, 
   3.5007506441073785`*^9, {3.5007507213474865`*^9, 3.500750734577505*^9}, {
   3.5007516906588435`*^9, 3.5007517043488626`*^9}, {3.5007517576689377`*^9, 
   3.5007517834289737`*^9}, {3.5007548086332088`*^9, 3.500754828393236*^9}, {
   3.50075495968342*^9, 3.500754982303452*^9}, {3.5008595239003787`*^9, 
   3.500859589750471*^9}, 3.500859741840684*^9, 3.501028137199436*^9, {
   3.5010281744985695`*^9, 3.5010282102176123`*^9}, 3.5077862560342236`*^9, {
   3.508728593993391*^9, 3.508728605365811*^9}, {3.508728681228744*^9, 
   3.5087286859399524`*^9}, {3.50878405336939*^9, 3.5087840545393925`*^9}, {
   3.509552918044816*^9, 3.5095529196360188`*^9}, {3.5105860304794407`*^9, 
   3.51058604435946*^9}, {3.5151896217255526`*^9, 3.515189623835555*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"A", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "-", 
    " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "B"}], "-", 
           RowBox[{"a", "*", "C", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.5007500405865335`*^9, 3.500750069596574*^9}, {
   3.500750792317586*^9, 3.5007507956375904`*^9}, {3.500750867397691*^9, 
   3.5007509035977416`*^9}, {3.500751863109085*^9, 3.5007518872391186`*^9}, {
   3.500751977369245*^9, 3.5007519775292454`*^9}, {3.500752692880247*^9, 
   3.50075271639028*^9}, 3.500754842423256*^9, {3.500755037563529*^9, 
   3.5007550761535835`*^9}, {3.5008596417705436`*^9, 3.500859649170554*^9}, 
   3.500859847170831*^9, {3.501028243941541*^9, 3.5010282690729785`*^9}, 
   3.501028527981787*^9, 3.504750261786316*^9, 3.507786315704328*^9, {
   3.5087840546953926`*^9, 3.5087840553973937`*^9}, {3.5087844698901215`*^9, 
   3.5087844832749453`*^9}, {3.5095529208060207`*^9, 
   3.5095529222412233`*^9}, {3.510586093299528*^9, 3.510586105789546*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"A", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "-", 
    " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "C", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.5007500405865335`*^9, 3.500750069596574*^9}, {
   3.500750792317586*^9, 3.5007507956375904`*^9}, {3.500750867397691*^9, 
   3.5007509035977416`*^9}, {3.500751863109085*^9, 3.5007518872391186`*^9}, {
   3.500751977369245*^9, 3.5007519775292454`*^9}, {3.500752692880247*^9, 
   3.50075271639028*^9}, 3.500754842423256*^9, {3.500755037563529*^9, 
   3.5007550761535835`*^9}, {3.5008596417705436`*^9, 3.500859649170554*^9}, 
   3.500859847170831*^9, {3.501028243941541*^9, 3.5010282690729785`*^9}, 
   3.501028527981787*^9, {3.50102982705809*^9, 3.5010298362916183`*^9}, 
   3.5010298846183825`*^9, 3.504753120150318*^9, 3.507779948818384*^9, {
   3.5077799871884375`*^9, 3.5077799948884487`*^9}, {3.508725723840747*^9, 
   3.5087257487855916`*^9}, {3.508783169674638*^9, 3.50878317092264*^9}, {
   3.509553093217511*^9, 3.5095530948275137`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["c",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.508615440708002*^9, 3.5086154744040613`*^9, {3.5086155092857227`*^9, 
   3.508615515681734*^9}, 3.508728756077676*^9, {3.5087840557873945`*^9, 
   3.5087840563801956`*^9}, {3.509552923052425*^9, 3.509552923754426*^9}, {
   3.5120747318742948`*^9, 3.512074732034295*^9}, 3.514854265129818*^9, {
   3.515189627835561*^9, 3.5151896287455626`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell[TextData[{
 "Rule c: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, 3.5087287582460794`*^9, 3.5148542675166225`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["C", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"a", " ", "C"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.50760116034864*^9, 3.5076011630086436`*^9}, {
   3.5087840565673957`*^9, 3.5087840617310047`*^9}, {3.5095529248776283`*^9, 
   3.509552926453231*^9}, {3.515189629375563*^9, 3.5151896317855663`*^9}, 
   3.5159794744920645`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B"}], "-", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.507601130198598*^9, 
   3.507601145458619*^9}, {3.508784062401806*^9, 3.508784065194211*^9}, {
   3.5095529267028313`*^9, 3.509552928450034*^9}, 3.5113830667825546`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "C", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.50381324270862*^9, 
   3.503813275515478*^9}, {3.507601248988764*^9, 3.5076012508587666`*^9}, {
   3.508783175321848*^9, 3.508783176944251*^9}, {3.509553095837515*^9, 
   3.5095530970775166`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["d",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.508615440708002*^9, 3.5086154744040613`*^9, {3.5086155092857227`*^9, 
   3.508615515681734*^9}, 3.508728756077676*^9, {3.508728790928137*^9, 
   3.5087287925505395`*^9}, {3.508784065771412*^9, 3.5087840664110126`*^9}, {
   3.5095529295108356`*^9, 3.509552930197237*^9}, {3.512074734244298*^9, 
   3.5120747344342985`*^9}, 3.5148542794662433`*^9, {3.5151896373255744`*^9, 
   3.5151896383055754`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}}],

Cell[TextData[{
 "Rule d: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4992133873636045`*^9, 3.4992133892036066`*^9}, {3.4992162641476316`*^9, 
   3.499216265707634*^9}, {3.4993685410928354`*^9, 3.4993685488628464`*^9}, {
   3.50031970240469*^9, 3.5003197069046965`*^9}, 3.500401902143732*^9, {
   3.5004019322673855`*^9, 3.5004019348725896`*^9}, {3.500431975630224*^9, 
   3.500431976700285*^9}, {3.500596487572508*^9, 3.5005964955909224`*^9}, {
   3.5005976481165457`*^9, 3.50059769596183*^9}, {3.50059778134078*^9, 
   3.5005977822611814`*^9}, 3.500603436159915*^9, {3.500752664340207*^9, 
   3.5007526883602405`*^9}, 3.500754770973156*^9, {3.5047492728249316`*^9, 
   3.5047492736849327`*^9}, 3.5047502914463577`*^9, 3.504764250818152*^9, 
   3.5087287941261425`*^9, 3.514854290823063*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["C", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"a", " ", "C"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5004019027833333`*^9, 3.5004019090077443`*^9}, {3.5004019461670094`*^9, 
   3.5004019604098344`*^9}, {3.5004020022023077`*^9, 
   3.5004020999052796`*^9}, {3.500403170537961*^9, 3.5004031709747615`*^9}, {
   3.5004032188980455`*^9, 3.500403243093688*^9}, {3.500596131704683*^9, 
   3.5005961322818837`*^9}, {3.500596573684659*^9, 3.50059658569668*^9}, {
   3.500596750360569*^9, 3.500596757676982*^9}, {3.5005968433423324`*^9, 
   3.500596857273157*^9}, {3.5005972743710895`*^9, 3.5005972953687263`*^9}, {
   3.5005986514683084`*^9, 3.5005986952419853`*^9}, {3.500598795206961*^9, 
   3.5005987969385643`*^9}, {3.5005989433292212`*^9, 
   3.5005989622364545`*^9}, {3.500691131426506*^9, 3.5006911595265455`*^9}, {
   3.500698437682624*^9, 3.5006985085691485`*^9}, {3.5006991256250324`*^9, 
   3.5006991261554337`*^9}, {3.500699909510809*^9, 3.5006999123968143`*^9}, {
   3.5007476294511504`*^9, 3.500747637191161*^9}, {3.500747709211262*^9, 
   3.500747734041297*^9}, {3.500749692956047*^9, 3.500749800106197*^9}, 
   3.5007506441073785`*^9, {3.5007507213474865`*^9, 3.500750734577505*^9}, {
   3.5007516906588435`*^9, 3.5007517043488626`*^9}, {3.5007517576689377`*^9, 
   3.5007517834289737`*^9}, {3.5007548086332088`*^9, 3.500754828393236*^9}, {
   3.50075495968342*^9, 3.500754982303452*^9}, {3.5087286150534277`*^9, 
   3.5087286604339075`*^9}, {3.508784066816614*^9, 3.508784068283016*^9}, {
   3.5095529309304385`*^9, 3.5095529323500414`*^9}, {3.5127835034537687`*^9, 
   3.512783505603771*^9}, {3.5151896389855766`*^9, 3.51518964100558*^9}, 
   3.515979460795241*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}],
      "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B"}], "-", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.5007500405865335`*^9, 3.500750069596574*^9}, {
   3.500750792317586*^9, 3.5007507956375904`*^9}, {3.500750867397691*^9, 
   3.5007509035977416`*^9}, {3.500751863109085*^9, 3.5007518872391186`*^9}, {
   3.500751977369245*^9, 3.5007519775292454`*^9}, {3.500752692880247*^9, 
   3.50075271639028*^9}, 3.500754842423256*^9, {3.500755037563529*^9, 
   3.5007550761535835`*^9}, 3.504750267216324*^9, {3.5087840687666173`*^9, 
   3.50878407032662*^9}, {3.5087845352074366`*^9, 3.5087845783883123`*^9}, {
   3.5095529325684414`*^9, 3.509552934300044*^9}, {3.5127835134637823`*^9, 
   3.512783547053829*^9}, 3.5135322902249126`*^9, 3.514475033510973*^9, 
   3.514579039145911*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}],
      "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", "*", "b"}], "-", 
           RowBox[{"a", "*", "C", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.4991796252286544`*^9, 3.499179629191061*^9}, {
   3.4991799423928113`*^9, 3.499179956230036*^9}, {3.499179994189703*^9, 
   3.49918001520294*^9}, 3.4991802628689747`*^9, {3.4991809464777756`*^9, 
   3.499180955822192*^9}, {3.499181041294742*^9, 3.499181080638011*^9}, 
   3.4991882648154335`*^9, {3.4992137616941285`*^9, 3.4992137626741295`*^9}, 
   3.4992139059543304`*^9, {3.4992140832345786`*^9, 3.4992141086946144`*^9}, 
   3.499214216934766*^9, {3.499216208717554*^9, 3.4992162138475614`*^9}, {
   3.4992164326178675`*^9, 3.499216489837948*^9}, {3.499216616588125*^9, 
   3.4992166411581593`*^9}, 3.4992167074782524`*^9, {3.499216790438369*^9, 
   3.4992167911383696`*^9}, 3.499216873638485*^9, {3.4993649181097364`*^9, 
   3.4993649626097984`*^9}, {3.499365011309867*^9, 3.4993650116798673`*^9}, {
   3.499365165120082*^9, 3.499365167950086*^9}, {3.4993654481904783`*^9, 
   3.499365494270543*^9}, {3.4993661831115074`*^9, 3.499366184461509*^9}, {
   3.5003179820849175`*^9, 3.500317982365718*^9}, 3.5003187900234127`*^9, {
   3.5003190903738327`*^9, 3.5003191035638514`*^9}, 3.5003192263540235`*^9, 
   3.5003207542961626`*^9, {3.5003443675174456`*^9, 3.5003443741274548`*^9}, {
   3.500401911082548*^9, 3.500401988302684*^9}, {3.50040213985695*^9, 
   3.5004021729914083`*^9}, {3.5004031800539775`*^9, 3.500403180319178*^9}, {
   3.500403232142469*^9, 3.500403268053732*^9}, {3.5004319798384647`*^9, 
   3.5004319809015255`*^9}, {3.5005965174777603`*^9, 3.500596550487418*^9}, {
   3.5005972239830008`*^9, 3.500597224747402*^9}, 3.500597471227835*^9, {
   3.5005975330039434`*^9, 3.5005975372471514`*^9}, {3.5005976992690353`*^9, 
   3.500597700205037*^9}, {3.500597773057165*^9, 3.5005977749135685`*^9}, 
   3.5005981390074086`*^9, 3.500598274290846*^9, {3.5005987787177324`*^9, 
   3.5005988410086412`*^9}, {3.5005988915527306`*^9, 3.500598897730341*^9}, {
   3.5006911912365904`*^9, 3.5006912140666223`*^9}, {3.500698375032914*^9, 
   3.5006983872945356`*^9}, {3.5006985524520254`*^9, 3.500698556804433*^9}, {
   3.500698594132099*^9, 3.5006986357997723`*^9}, {3.5006991295250397`*^9, 
   3.500699130492241*^9}, {3.5006999309920473`*^9, 3.5006999574028935`*^9}, {
   3.5007476502811794`*^9, 3.5007476639111986`*^9}, {3.5007477113312654`*^9, 
   3.5007477359912996`*^9}, {3.5007481338098617`*^9, 3.500748134229862*^9}, {
   3.5007484134002533`*^9, 3.5007484296702757`*^9}, {3.5007489493750057`*^9, 
   3.5007489584850187`*^9}, {3.500749461305722*^9, 3.500749464515727*^9}, 
   3.5007498178562217`*^9, {3.5007500405865335`*^9, 3.500750069596574*^9}, {
   3.500750792317586*^9, 3.5007507956375904`*^9}, {3.500750867397691*^9, 
   3.5007509035977416`*^9}, {3.500751863109085*^9, 3.5007518872391186`*^9}, {
   3.500751977369245*^9, 3.5007519775292454`*^9}, {3.500752692880247*^9, 
   3.50075271639028*^9}, 3.500754842423256*^9, {3.500755037563529*^9, 
   3.5007550761535835`*^9}, 3.504750267216324*^9, {3.50475329994057*^9, 
   3.504753337210622*^9}, {3.508725823634523*^9, 3.5087258627125916`*^9}, {
   3.5087259182330894`*^9, 3.5087259303075104`*^9}, {3.5087831809066577`*^9, 
   3.50878318213906*^9}, {3.509553099887521*^9, 3.5095531015175233`*^9}, 
   3.514475035804177*^9, 3.5145790425359163`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["e",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.508615440708002*^9, 3.5086154744040613`*^9, 3.508728804702961*^9, {
   3.5087840712158213`*^9, 3.5087840718242226`*^9}, {3.509552935641647*^9, 
   3.5095529363280478`*^9}, {3.512074736204301*^9, 3.512074736384301*^9}, 
   3.514854280558245*^9, {3.515189645645586*^9, 3.515189646365587*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule e1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"2", " ", "b", " ", "A"}], "-", 
     RowBox[{"a", " ", "C"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5040286788233967`*^9, 3.504028680149399*^9}, {3.5040318413657513`*^9, 
   3.504031854095373*^9}, 3.5043111510915785`*^9, {3.5086151666675205`*^9, 
   3.5086151690855246`*^9}, 3.508615480862473*^9, {3.508784186484424*^9, 
   3.5087841867964244`*^9}, {3.5148542989350777`*^9, 3.514854299215878*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"A", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"C", 
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"c", "-", 
            FractionBox["\[Pi]", "2"], "+", 
            RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}], 
       RowBox[{"b", " ", "d"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["C", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.5076011964286904`*^9, 3.5076011984086933`*^9}, 
   3.508612415913888*^9, {3.508613633268027*^9, 3.508613667026486*^9}, {
   3.5086137503618326`*^9, 3.5086137510014334`*^9}, {3.508615144515482*^9, 
   3.508615151395094*^9}, {3.5086552055415297`*^9, 3.5086552092915354`*^9}, 
   3.508655303391667*^9, {3.509552936577648*^9, 3.5095529421780586`*^9}, 
   3.509899586450349*^9, {3.5151896466655874`*^9, 3.515189649315591*^9}, 
   3.51597949999811*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"C", "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "-", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"C", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ")"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "b", "*", "A"}], "-", 
      RowBox[{"a", "*", "C"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508612395275052*^9, 3.5086124053838696`*^9}, {
   3.508615113908228*^9, 3.508615118151435*^9}, {3.508615201902783*^9, 
   3.5086152036499863`*^9}, {3.508615281322522*^9, 3.508615294769746*^9}, 
   3.5086212007556057`*^9, {3.508655209981536*^9, 3.50865521279154*^9}, {
   3.5086553059416704`*^9, 3.508655307431672*^9}, {3.50955294300486*^9, 
   3.5095529452044635`*^9}, 3.509899677090476*^9, {3.509899918820814*^9, 
   3.5098999261908245`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, 
   3.514164218001401*^9}],

Cell[TextData[{
 "Rule e2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5040286788233967`*^9, 3.504028680149399*^9}, {3.5040318413657513`*^9, 
   3.504031854095373*^9}, 3.5043111510915785`*^9, 3.5086154863380823`*^9, 
   3.508623513520469*^9, 3.5087261390514765`*^9, 3.514164218001401*^9, 
   3.514164365271607*^9, {3.5148543022890835`*^9, 3.5148543029754844`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "A"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"C", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.5076011964286904`*^9, 
   3.5076011984086933`*^9}, {3.5086134541329117`*^9, 
   3.5086134840225644`*^9}, {3.5086234290931206`*^9, 3.508623455347967*^9}, {
   3.5086235377161117`*^9, 3.508623555999344*^9}, {3.5087831835274625`*^9, 
   3.508783184869065*^9}, {3.509553103037525*^9, 3.5095531036875257`*^9}, {
   3.5151896568556013`*^9, 3.515189659015605*^9}, 3.515979504693718*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"C", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508613364916355*^9, 3.5086133684263616`*^9}, 
   3.5086135058158026`*^9, 3.508613547577076*^9, {3.5086211727379565`*^9, 
   3.5086211865439806`*^9}, {3.508623480292411*^9, 3.508623484566818*^9}, 
   3.5086236538739157`*^9, {3.5086237301892495`*^9, 3.5086237539636917`*^9}, {
   3.508623793384961*^9, 3.508623793556561*^9}, {3.508623845582652*^9, 
   3.508623845816653*^9}, {3.5087831851030655`*^9, 3.508783186834668*^9}, {
   3.509553103717526*^9, 3.5095531052875285`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell[TextData[{
 "Rule e3: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5040286788233967`*^9, 3.504028680149399*^9}, {3.5040318413657513`*^9, 
   3.504031854095373*^9}, 3.5043111510915785`*^9, 3.5086154863380823`*^9, {
   3.508637580735584*^9, 3.508637581219185*^9}, {3.508728810506171*^9, 
   3.5087288111301727`*^9}, {3.51416436753161*^9, 3.514164368341611*^9}, {
   3.51485430622029*^9, 3.5148543064386907`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["1", 
       RowBox[{"2", "b"}]]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"2", "b", " ", "A"}], "-", 
        RowBox[{"a", " ", "C"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "b", " ", "B"}], "-", 
           RowBox[{"a", " ", "C"}]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["C", 
    RowBox[{"2", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", "b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.5076011964286904`*^9, 
   3.5076011984086933`*^9}, {3.5086134541329117`*^9, 
   3.5086134840225644`*^9}, {3.508637460802573*^9, 3.5086375082110567`*^9}, {
   3.5086375524839344`*^9, 3.508637569144764*^9}, 3.5086558851924815`*^9, {
   3.5087840827130413`*^9, 3.5087840849438457`*^9}, {3.5095529468580666`*^9, 
   3.50955294885487*^9}, {3.515189663735611*^9, 3.5151896673856163`*^9}, 
   3.515979510044527*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "b", "*", "A"}], "-", 
           RowBox[{"a", "*", "C"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "b", "*", "B"}], "-", 
              RowBox[{"a", "*", "C"}]}], ")"}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"2", "*", "b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508613364916355*^9, 3.5086133684263616`*^9}, 
   3.5086135058158026`*^9, 3.508613547577076*^9, {3.5086211727379565`*^9, 
   3.5086211865439806`*^9}, {3.5086376427612925`*^9, 3.508637653852912*^9}, {
   3.5087840851310463`*^9, 3.5087840871278496`*^9}, {3.5095529490576706`*^9, 
   3.5095529520372753`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["f",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"3", "/", "2"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.508615440708002*^9, 3.5086154744040613`*^9, {3.508615573152235*^9, 
   3.5086155785810447`*^9}, {3.508625855983385*^9, 3.508625866248203*^9}, 
   3.508728823672594*^9, {3.5087840873462496`*^9, 3.508784088001451*^9}, {
   3.5095529536440783`*^9, 3.5095529542992797`*^9}, {3.5120747386143045`*^9, 
   3.512074738794305*^9}, {3.514600924470538*^9, 3.5146009692006006`*^9}, 
   3.5148542820090475`*^9, {3.515189671505622*^9, 3.5151896724856234`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule f: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5040286788233967`*^9, 3.504028680149399*^9}, {3.5040318413657513`*^9, 
   3.504031854095373*^9}, 3.5043111510915785`*^9, 3.5086154863380823`*^9, 
   3.50861825990904*^9, {3.508626490608099*^9, 3.508626506910128*^9}, 
   3.5087288260749984`*^9, 3.5146009217605343`*^9, 3.514600973060606*^9, 
   3.514601153680859*^9, 3.514854315720707*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "C"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B", "-", "C"}], ")"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.5076011964286904`*^9, 
   3.5076011984086933`*^9}, {3.5086134541329117`*^9, 
   3.5086134840225644`*^9}, {3.5086176232875214`*^9, 
   3.5086177017868595`*^9}, {3.508617757525758*^9, 3.5086177682897763`*^9}, {
   3.508617802906237*^9, 3.5086178407519035`*^9}, {3.5086180217746215`*^9, 
   3.508618067966303*^9}, 3.508618118666392*^9, {3.5086258789934254`*^9, 
   3.508625931955518*^9}, {3.508626098548211*^9, 3.508626126004259*^9}, {
   3.508784088188651*^9, 3.5087840933990602`*^9}, {3.5095529552820816`*^9, 
   3.509552957216485*^9}, {3.5146010110806594`*^9, 3.5146011128408017`*^9}, {
   3.5146012858510437`*^9, 3.514601289611049*^9}, {3.515189673355625*^9, 
   3.5151896765156293`*^9}, 3.515979539297778*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"C", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"B", "-", "C"}], ")"}], "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508613364916355*^9, 3.5086133684263616`*^9}, 
   3.5086135058158026`*^9, 3.508613547577076*^9, {3.508617717886088*^9, 
   3.508617718525689*^9}, 3.5086181809729013`*^9, 3.5086182775526705`*^9, {
   3.5086192962792606`*^9, 3.5086193025816717`*^9}, 3.508619830000198*^9, {
   3.5086262663889055`*^9, 3.5086262876985426`*^9}, 3.5086263728590927`*^9, {
   3.5086264315307956`*^9, 3.508626467473259*^9}, {3.5087840942414618`*^9, 
   3.50878409884347*^9}, {3.509552957450485*^9, 3.509552961194492*^9}, {
   3.512078473115609*^9, 3.5120784789856176`*^9}, {3.51207883074611*^9, 
   3.5120788338361144`*^9}, {3.5145995532686186`*^9, 
   3.5145995614886303`*^9}, {3.5146011198708115`*^9, 
   3.5146011462908487`*^9}, {3.5146012047309303`*^9, 3.514601266391017*^9}, {
   3.514601306681073*^9, 3.514601310721079*^9}, {3.514601380041176*^9, 
   3.5146014162512264`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"C", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "-", 
         RowBox[{"C", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508613364916355*^9, 3.5086133684263616`*^9}, 
   3.5086135058158026`*^9, 3.508613547577076*^9, {3.508617717886088*^9, 
   3.508617718525689*^9}, 3.5086181809729013`*^9, 3.5086182775526705`*^9, {
   3.5086192962792606`*^9, 3.5086193025816717`*^9}, 3.508619830000198*^9, {
   3.5086262663889055`*^9, 3.5086262876985426`*^9}, 3.5086263728590927`*^9, {
   3.5086264315307956`*^9, 3.508626467473259*^9}, {3.5086266251583357`*^9, 
   3.5086266564831905`*^9}, {3.5087831915302763`*^9, 
   3.5087831970214863`*^9}, {3.5095531089475336`*^9, 
   3.5095531143675413`*^9}, {3.514599567168638*^9, 3.5145995760086503`*^9}, {
   3.5146011504208546`*^9, 3.514601192930914*^9}, {3.514601231160968*^9, 
   3.5146012449809866`*^9}, {3.5146012769010315`*^9, 
   3.5146012810910378`*^9}, {3.514601316411087*^9, 3.5146013491011324`*^9}, {
   3.5146014019212065`*^9, 3.514601412991222*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["g",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.508615440708002*^9, 3.5086154744040613`*^9, {3.508615573152235*^9, 
   3.5086155785810447`*^9}, {3.508625855983385*^9, 3.508625866248203*^9}, 
   3.508728823672594*^9, {3.5087840873462496`*^9, 3.508784088001451*^9}, {
   3.5095529536440783`*^9, 3.5095529542992797`*^9}, {3.5120747386143045`*^9, 
   3.512074738794305*^9}, {3.514600550670015*^9, 3.514600551430016*^9}, 
   3.5146009750006084`*^9, {3.5146013566611433`*^9, 3.514601359531147*^9}, 
   3.514854283959051*^9, {3.515189682855638*^9, 3.515189683625639*^9}, {
   3.516413560329754*^9, 3.5164135619797564`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell["\<\
Note: This rule is not essential, but produces simpler results.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.512080133307934*^9, 3.512080168407983*^9}}],

Cell[TextData[{
 "Rule g: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5040286788233967`*^9, 3.504028680149399*^9}, {3.5040318413657513`*^9, 
   3.504031854095373*^9}, 3.5043111510915785`*^9, 3.5086154863380823`*^9, 
   3.50861825990904*^9, {3.508626490608099*^9, 3.508626506910128*^9}, 
   3.5087288260749984`*^9, {3.514600607770095*^9, 3.514600610150098*^9}, 
   3.514600980180616*^9, 3.51485432913673*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["C", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "C"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"C", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.5076011964286904`*^9, 
   3.5076011984086933`*^9}, {3.5086134541329117`*^9, 
   3.5086134840225644`*^9}, {3.5086176232875214`*^9, 
   3.5086177017868595`*^9}, {3.508617757525758*^9, 3.5086177682897763`*^9}, {
   3.508617802906237*^9, 3.5086178407519035`*^9}, {3.5086180217746215`*^9, 
   3.508618067966303*^9}, 3.508618118666392*^9, {3.5086258789934254`*^9, 
   3.508625931955518*^9}, {3.508626098548211*^9, 3.508626126004259*^9}, {
   3.508784088188651*^9, 3.5087840933990602`*^9}, {3.5095529552820816`*^9, 
   3.509552957216485*^9}, {3.514600564480034*^9, 3.5146005725800457`*^9}, {
   3.5146006237501173`*^9, 3.5146006410501413`*^9}, 3.51460179025175*^9, {
   3.5151896844756403`*^9, 3.5151896876156445`*^9}, 3.515979546551791*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "C"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "B"}], "-", 
              RowBox[{"C", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", "b"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508613364916355*^9, 3.5086133684263616`*^9}, 
   3.5086135058158026`*^9, 3.508613547577076*^9, {3.508617717886088*^9, 
   3.508617718525689*^9}, 3.5086181809729013`*^9, 3.5086182775526705`*^9, {
   3.5086192962792606`*^9, 3.5086193025816717`*^9}, 3.508619830000198*^9, {
   3.5086262663889055`*^9, 3.5086262876985426`*^9}, 3.5086263728590927`*^9, {
   3.5086264315307956`*^9, 3.508626467473259*^9}, {3.5087840942414618`*^9, 
   3.50878409884347*^9}, {3.509552957450485*^9, 3.509552961194492*^9}, {
   3.512078473115609*^9, 3.5120784789856176`*^9}, {3.51207883074611*^9, 
   3.5120788338361144`*^9}, {3.5145995532686186`*^9, 
   3.5145995614886303`*^9}, {3.514600689170209*^9, 3.5146007175202484`*^9}, {
   3.5146007539702997`*^9, 3.514600832240409*^9}, 3.514600883640481*^9, {
   3.5146018103417788`*^9, 3.514601819501791*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"C", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "A"}], "-", 
           RowBox[{"a", "*", "C"}], "-", 
           RowBox[{"C", "*", 
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, {3.507601176658663*^9, 
   3.507601191678684*^9}, {3.508613364916355*^9, 3.5086133684263616`*^9}, 
   3.5086135058158026`*^9, 3.508613547577076*^9, {3.508617717886088*^9, 
   3.508617718525689*^9}, 3.5086181809729013`*^9, 3.5086182775526705`*^9, {
   3.5086192962792606`*^9, 3.5086193025816717`*^9}, 3.508619830000198*^9, {
   3.5086262663889055`*^9, 3.5086262876985426`*^9}, 3.5086263728590927`*^9, {
   3.5086264315307956`*^9, 3.508626467473259*^9}, {3.5086266251583357`*^9, 
   3.5086266564831905`*^9}, {3.5087831915302763`*^9, 
   3.5087831970214863`*^9}, {3.5095531089475336`*^9, 
   3.5095531143675413`*^9}, {3.514599567168638*^9, 3.5145995760086503`*^9}, {
   3.514600722070255*^9, 3.5146008252003994`*^9}, 3.514600886780485*^9, 
   3.5146015717814445`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["h",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.5144732893239093`*^9, 
   3.5144732896047096`*^9}, 3.5144733582916307`*^9, 3.5144734005053043`*^9, 
   3.5144793880362206`*^9, 3.5144798140885687`*^9, {3.5145737444784985`*^9, 
   3.5145737543285127`*^9}, {3.514854546866313*^9, 3.5148545512343206`*^9}, {
   3.5151896933056526`*^9, 3.5151896941856537`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5144736871714077`*^9, 3.5144736908686147`*^9}}],

Cell[TextData[{
 "Rule h1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.5144794121226625`*^9, 3.5144794127622643`*^9}, {
   3.5145737646985273`*^9, 3.5145737646985273`*^9}, {3.514854592621193*^9, 
   3.514854595179598*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"k", " ", "m"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{
       RowBox[{"k", " ", "m"}], "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107893359082437`*^9, 3.5107893412382507`*^9}, 
   3.5107893780883026`*^9, 3.510845655897318*^9, {3.5144732957199206`*^9, 
   3.514473295938321*^9}, {3.5144733271383758`*^9, 3.514473389632086*^9}, {
   3.5144734208321404`*^9, 3.514473425184548*^9}, {3.514473474153034*^9, 
   3.514473504229887*^9}, {3.514479396491435*^9, 3.514479399720641*^9}, {
   3.5144798175205746`*^9, 3.5144798417630177`*^9}, 3.5145764840523343`*^9, {
   3.515189695685656*^9, 3.5151896987856607`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"k", "*", "m"}], ")"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", "*", "m"}], "+", "n"}], ")"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.5144735757092123`*^9, 3.5144736765009894`*^9}, {
   3.514473929112233*^9, 3.5144739317798376`*^9}, {3.514474664049924*^9, 
   3.5144746883547664`*^9}, {3.514474786463339*^9, 3.514474821750601*^9}, {
   3.5144794332138996`*^9, 3.5144794708567657`*^9}, 3.5144795462828984`*^9, {
   3.514479724326011*^9, 3.514479727071616*^9}, {3.514479783044514*^9, 
   3.514479789814926*^9}, {3.514479869453066*^9, 3.5144799155667467`*^9}, {
   3.514479990712079*^9, 3.514479998044092*^9}, {3.514480028495345*^9, 
   3.514480049352582*^9}, 3.5144800990230694`*^9, {3.5145737688285327`*^9, 
   3.514573782448552*^9}, {3.515979638150752*^9, 3.515979639164754*^9}, 
   3.516821226927261*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"k", "*", "m"}], ")"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", "*", "m"}], "+", "n"}], ")"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.5144735757092123`*^9, 3.5144736765009894`*^9}, {
   3.514473929112233*^9, 3.5144739317798376`*^9}, {3.514474664049924*^9, 
   3.5144746883547664`*^9}, {3.514474786463339*^9, 3.514474821750601*^9}, {
   3.5144794332138996`*^9, 3.5144794708567657`*^9}, 3.5144795462828984`*^9, {
   3.514479724326011*^9, 3.514479727071616*^9}, {3.514479783044514*^9, 
   3.514479789814926*^9}, {3.514479869453066*^9, 3.5144799155667467`*^9}, {
   3.514479990712079*^9, 3.514479998044092*^9}, {3.514480028495345*^9, 
   3.514480049352582*^9}, {3.5144800886490507`*^9, 3.5144801020962744`*^9}, 
   3.5144805280082226`*^9, {3.514573771748537*^9, 3.5145737850885553`*^9}, 
   3.516821226947261*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "k"]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], 
      RowBox[{"j", " ", "k"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, 
   3.5145721515462685`*^9}],

Cell[TextData[{
 "Rule h2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.5117295035766306`*^9, 3.511729505106633*^9}, {
   3.511750898236919*^9, 3.5117508991769204`*^9}, {3.5117555222533927`*^9, 
   3.5117555300634036`*^9}, {3.5118334045968*^9, 3.511833408403207*^9}, 
   3.5145720728661585`*^9, {3.514854598939204*^9, 3.514854599500805*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"]], ")"}], 
       RowBox[{"j", " ", "k"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "+", 
       RowBox[{"k", " ", "n"}]}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.5118158169600077`*^9, 
   3.511815862160071*^9}, 3.511815909280137*^9, {3.5118176520325766`*^9, 
   3.5118176689026003`*^9}, 3.5118179461929884`*^9, {3.511819812927603*^9, 
   3.5118198181376104`*^9}, {3.5118198622576723`*^9, 3.511819864577675*^9}, {
   3.5145719907960434`*^9, 3.51457201659608*^9}, {3.5145764595823*^9, 
   3.5145764873023386`*^9}, {3.5151897066456714`*^9, 3.5151897088756742`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}]}]}], ",", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "+", 
           RowBox[{"k", "*", "n"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.5117293456064095`*^9, 3.5117294275865245`*^9}, {3.5117296689768624`*^9, 
   3.5117296728068676`*^9}, {3.5117302889377303`*^9, 3.5117303011477475`*^9}, 
   3.5117466386965055`*^9, {3.511750894036913*^9, 3.511750894676914*^9}, {
   3.5117511267572393`*^9, 3.5117511307372446`*^9}, {3.5117512119573584`*^9, 
   3.511751214027361*^9}, {3.511751883348298*^9, 3.5117518878683043`*^9}, {
   3.5117519413583794`*^9, 3.511751948148389*^9}, {3.5117521986187396`*^9, 
   3.511752203998747*^9}, {3.511755503353366*^9, 3.5117555064233704`*^9}, {
   3.5118335100217853`*^9, 3.5118335340614276`*^9}, 3.5145720383461103`*^9, {
   3.5145721800463085`*^9, 3.5145722335263834`*^9}, {3.5145739029787207`*^9, 
   3.514573906858726*^9}, {3.5145765100923705`*^9, 3.514576532442402*^9}, {
   3.514576566192449*^9, 3.514576575982463*^9}, {3.5159796433299613`*^9, 
   3.515979644328363*^9}, 3.516820779976635*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}]}]}], ",", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "+", 
           RowBox[{"k", "*", "n"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.5117293456064095`*^9, 3.5117294275865245`*^9}, {3.5117296689768624`*^9, 
   3.5117296728068676`*^9}, {3.5117302889377303`*^9, 3.5117303011477475`*^9}, 
   3.5117466386965055`*^9, {3.511750894036913*^9, 3.511750894676914*^9}, {
   3.5117511267572393`*^9, 3.5117511307372446`*^9}, {3.5117512119573584`*^9, 
   3.511751214027361*^9}, {3.511751883348298*^9, 3.5117518878683043`*^9}, {
   3.5117519413583794`*^9, 3.511751948148389*^9}, {3.5117521986187396`*^9, 
   3.511752203998747*^9}, {3.511755503353366*^9, 3.5117555064233704`*^9}, {
   3.5118335100217853`*^9, 3.5118335340614276`*^9}, 3.5145720383461103`*^9, {
   3.5145721800463085`*^9, 3.5145722335263834`*^9}, {3.5145739029787207`*^9, 
   3.514573906858726*^9}, {3.5145765100923705`*^9, 3.514576532442402*^9}, {
   3.514576566192449*^9, 3.514576575982463*^9}, {3.5145766229825287`*^9, 
   3.514576629262538*^9}, 3.5168207799966354`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], 
      RowBox[{"j", " ", "k"}]], 
     SqrtBox[
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "k"]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, {
   3.5118187344240923`*^9, 3.5118187409841013`*^9}, {3.514569048341924*^9, 
   3.5145690628419447`*^9}, {3.5145721153562183`*^9, 3.5145721159962187`*^9}}],

Cell[TextData[{
 "Rule h3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.511729526906664*^9, 3.5117295274366646`*^9}, {
   3.511748932814161*^9, 3.511748933464162*^9}, {3.5117557724437428`*^9, 
   3.5117557724437428`*^9}, {3.511832614206211*^9, 3.511832614206211*^9}, {
   3.511832746213642*^9, 3.511832746213642*^9}, {3.5144963686357794`*^9, 
   3.514496369905781*^9}, {3.5144964549259*^9, 3.5144964623659105`*^9}, {
   3.514496962866611*^9, 3.5144969631666117`*^9}, {3.5144973205371118`*^9, 
   3.514497323707116*^9}, {3.5144981061082115`*^9, 3.514498107108213*^9}, {
   3.51456888104169*^9, 3.51456888104169*^9}, {3.5145720563361354`*^9, 
   3.514572061146142*^9}, {3.514854603759613*^9, 3.514854604711214*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "+", 
         FractionBox["1", "2"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         SqrtBox[
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"]], ")"}], 
        RowBox[{"j", " ", "k"}]]}], 
      SqrtBox[
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "+", 
       RowBox[{"k", " ", "n"}]}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.51174841818344*^9, 
   3.511748420833444*^9}, {3.511748497963552*^9, 3.5117484984135523`*^9}, {
   3.511818294033475*^9, 3.5118183236735168`*^9}, {3.5144968024863863`*^9, 
   3.5144968510064545`*^9}, {3.5144968866465044`*^9, 3.514496913836542*^9}, {
   3.514568305910885*^9, 3.5145683164908996`*^9}, {3.5145683572009563`*^9, 
   3.5145683609609623`*^9}, 3.514568478731127*^9, 3.514568528181196*^9, {
   3.5145685692312536`*^9, 3.5145686286113367`*^9}, {3.5145686608513813`*^9, 
   3.5145686672213907`*^9}, {3.514569441722475*^9, 3.5145694478724833`*^9}, {
   3.514576462582304*^9, 3.514576491462344*^9}, {3.515189713495681*^9, 
   3.515189715175683*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}]}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "+", 
           RowBox[{"k", "*", "n"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.511747293362056*^9, 3.5117472971996627`*^9}, {3.5117477460436506`*^9, 
   3.5117477523148623`*^9}, {3.5117479077127256`*^9, 3.511747926872752*^9}, {
   3.5117482704932337`*^9, 3.511748288643259*^9}, {3.511748542813615*^9, 
   3.511748551293627*^9}, {3.511750065125746*^9, 3.5117500670757484`*^9}, {
   3.5117558949839144`*^9, 3.511755900293922*^9}, 3.51183280157814*^9, {
   3.511832873725067*^9, 3.5118328862830887`*^9}, {3.5118329289491634`*^9, 
   3.5118329301035657`*^9}, {3.514496374415787*^9, 3.514496375635789*^9}, {
   3.514496438775877*^9, 3.514496443085883*^9}, {3.514496942236582*^9, 
   3.514496946806588*^9}, {3.514497149116872*^9, 3.5144971791969137`*^9}, 
   3.5144972624770308`*^9, {3.5144973102370973`*^9, 3.5144973301571255`*^9}, {
   3.514497805537791*^9, 3.5144978555678606`*^9}, 3.5144981017882056`*^9, {
   3.5145668229448023`*^9, 3.5145668520048428`*^9}, {3.5145683337309237`*^9, 
   3.514568353430951*^9}, 3.5145688737116795`*^9, {3.514568913051735*^9, 
   3.5145689928618464`*^9}, {3.5145694700325146`*^9, 
   3.5145694900025425`*^9}, {3.5145720407761135`*^9, 
   3.5145720443261185`*^9}, {3.5145739099687304`*^9, 
   3.5145739137987356`*^9}, {3.5145765136923757`*^9, 
   3.5145765362824073`*^9}, {3.514576583412473*^9, 3.5145765900724826`*^9}, {
   3.5159796514887753`*^9, 3.5159796525339775`*^9}, 3.5168207800366354`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}]}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "+", 
           RowBox[{"k", "*", "n"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.511747293362056*^9, 3.5117472971996627`*^9}, {3.5117477460436506`*^9, 
   3.5117477523148623`*^9}, {3.5117479077127256`*^9, 3.511747926872752*^9}, {
   3.5117482704932337`*^9, 3.511748288643259*^9}, {3.511748542813615*^9, 
   3.511748551293627*^9}, {3.511750065125746*^9, 3.5117500670757484`*^9}, {
   3.5117558949839144`*^9, 3.511755900293922*^9}, 3.51183280157814*^9, {
   3.511832873725067*^9, 3.5118328862830887`*^9}, {3.5118329289491634`*^9, 
   3.5118329301035657`*^9}, {3.514496374415787*^9, 3.514496375635789*^9}, {
   3.514496438775877*^9, 3.514496443085883*^9}, {3.514496942236582*^9, 
   3.514496946806588*^9}, {3.514497149116872*^9, 3.5144971791969137`*^9}, 
   3.5144972624770308`*^9, {3.5144973102370973`*^9, 3.5144973301571255`*^9}, {
   3.514497805537791*^9, 3.5144978555678606`*^9}, 3.5144981017882056`*^9, {
   3.5145668229448023`*^9, 3.5145668520048428`*^9}, {3.5145683337309237`*^9, 
   3.514568353430951*^9}, 3.5145688737116795`*^9, {3.514568913051735*^9, 
   3.5145689928618464`*^9}, {3.5145694700325146`*^9, 
   3.5145694900025425`*^9}, {3.5145720407761135`*^9, 
   3.5145720443261185`*^9}, {3.5145739099687304`*^9, 
   3.5145739137987356`*^9}, {3.5145765136923757`*^9, 
   3.5145765362824073`*^9}, {3.514576583412473*^9, 3.5145765900724826`*^9}, {
   3.51457663807255*^9, 3.51457664524256*^9}, 3.516820780056635*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["i",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, {3.5107928856612177`*^9, 
   3.5107928921712275`*^9}, 3.5107929324812837`*^9, {3.5108631794008274`*^9, 
   3.5108631876408386`*^9}, {3.5112021365982804`*^9, 
   3.5112021374882812`*^9}, {3.5148545477711143`*^9, 3.514854552934724*^9}, {
   3.5151897189656887`*^9, 3.5151897514557343`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992213471847477`*^9, 3.499221352834756*^9}, {
   3.507168628069942*^9, 3.5071686300799446`*^9}}],

Cell[TextData[{
 "Rule i1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "\[LessEqual]", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5119745211854286`*^9, 3.5119745333741255`*^9}, {
   3.5119746039351616`*^9, 3.5119746039351616`*^9}, {3.511974690921137*^9, 
   3.5119746917231827`*^9}, {3.5136223236876483`*^9, 
   3.5136223236876483`*^9}, {3.5142253653249474`*^9, 
   3.5142253666197495`*^9}, {3.5148546489528923`*^9, 3.5148546501228943`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "-", "j"}]], 
         RowBox[{"(", 
          RowBox[{"C", "+", 
           RowBox[{"B", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
           RowBox[{"A", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}], 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, {3.51518975549574*^9, 3.5151897631357503`*^9}, {
   3.5151898049158087`*^9, 3.5151898090758147`*^9}, 3.5159795792650485`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}], "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "j"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"A", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "\[LessEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, {3.511974364864487*^9, 3.511974387232767*^9}, {
   3.511974460323947*^9, 3.5119744739837284`*^9}, 3.5119745976478014`*^9, {
   3.5119746946573505`*^9, 3.5119746955714025`*^9}, 3.513141338188531*^9, 
   3.5136221987002287`*^9, {3.5142253557309303`*^9, 3.5142253574157333`*^9}, 
   3.5142255591552877`*^9, {3.5159796218019238`*^9, 3.515979622893925*^9}, 
   3.5168210731170454`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "j"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "\[LessEqual]", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510794163895009*^9, 3.510794191825048*^9}, {3.510799222156905*^9, 
   3.51079923293692*^9}, {3.5107997631276627`*^9, 3.5107997707176733`*^9}, {
   3.5119751566217732`*^9, 3.511975166603344*^9}, 3.513141384910613*^9, 
   3.5136224586590853`*^9, {3.5142253599741383`*^9, 3.514225361565341*^9}, 
   3.514225560793291*^9, 3.516821073137046*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}}],

Cell[TextData[{
 "Rule i2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.513116837690441*^9, 3.513116838850443*^9}, {3.5131168870505104`*^9, 
   3.5131169674606233`*^9}, {3.513117014490689*^9, 3.5131170383307223`*^9}, 
   3.513130565956607*^9, {3.513622333515665*^9, 3.513622345137686*^9}, {
   3.514854654568902*^9, 3.514854655738904*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{" ", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{" ", 
       RowBox[{"C", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"A", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5131300342358627`*^9, 3.513130068685911*^9}, {3.513130217396119*^9, 
   3.513130277346203*^9}, {3.513130365816327*^9, 3.5131304152363963`*^9}, 
   3.513131963252816*^9, 3.5142595480365763`*^9, {3.515189770455761*^9, 
   3.515189778475772*^9}, {3.5151898160958247`*^9, 3.5151898198258295`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}], "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", "\n", "    ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"B", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.513111782769415*^9, 3.5131117863730216`*^9}, {
   3.5131118357471085`*^9, 3.5131118751371775`*^9}, 3.5131122932851124`*^9, {
   3.513115838129036*^9, 3.5131158726790843`*^9}, 3.5131171172908325`*^9, {
   3.513127235875329*^9, 3.513127277496202*^9}, {3.5131275419790664`*^9, 
   3.513127554927089*^9}, {3.5131276542524633`*^9, 3.513127662504878*^9}, {
   3.513127911602891*^9, 3.51312796069296*^9}, {3.5131280711931143`*^9, 
   3.5131280782331247`*^9}, {3.513128411653591*^9, 3.5131284272036133`*^9}, {
   3.5131284632336636`*^9, 3.5131284712536745`*^9}, {3.513128726044031*^9, 
   3.513128736534046*^9}, {3.5131289562943535`*^9, 3.5131289833743916`*^9}, {
   3.5131294719950757`*^9, 3.513129473955078*^9}, {3.5131298770756426`*^9, 
   3.5131298853556547`*^9}, {3.5131301161459775`*^9, 
   3.5131301747760596`*^9}, {3.513130548586583*^9, 3.5131305489665833`*^9}, {
   3.5131306209766846`*^9, 3.5131306870867767`*^9}, {3.5136222983376036`*^9, 
   3.513622301317209*^9}, 3.514250952824543*^9, {3.5159796169659147`*^9, 
   3.5159796180267167`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.513111782769415*^9, 3.5131117863730216`*^9}, {
   3.5131118357471085`*^9, 3.5131118751371775`*^9}, 3.5131122932851124`*^9, {
   3.513115838129036*^9, 3.5131158726790843`*^9}, 3.5131171172908325`*^9, {
   3.513127235875329*^9, 3.513127277496202*^9}, {3.5131275419790664`*^9, 
   3.513127554927089*^9}, {3.5131276542524633`*^9, 3.513127662504878*^9}, {
   3.513127911602891*^9, 3.51312796069296*^9}, {3.5131280711931143`*^9, 
   3.5131280782331247`*^9}, {3.513128411653591*^9, 3.5131284272036133`*^9}, {
   3.5131284632336636`*^9, 3.5131284712536745`*^9}, {3.513128726044031*^9, 
   3.513128736534046*^9}, {3.5131289562943535`*^9, 3.5131289833743916`*^9}, {
   3.5131294719950757`*^9, 3.513129473955078*^9}, {3.5131298770756426`*^9, 
   3.5131298853556547`*^9}, {3.5131301161459775`*^9, 
   3.5131301747760596`*^9}, {3.513130548586583*^9, 3.5131305489665833`*^9}, {
   3.5131306209766846`*^9, 3.5131306870867767`*^9}, {3.51313283797405*^9, 
   3.513132844594059*^9}, {3.513622461935091*^9, 3.513622465663498*^9}, 
   3.5142509551445465`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], "j"], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], 
          RowBox[{"-", "1"}]]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}}],

Cell[TextData[{
 "Rule i3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{"j", " ", "m"}]}], "=", 
    FractionBox["1", "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, {3.514225012031127*^9, 
   3.514225013247929*^9}, {3.5142251131193047`*^9, 3.514225145832562*^9}, {
   3.514253810168543*^9, 3.514253840658586*^9}, {3.514395770421965*^9, 
   3.51439577397197*^9}, {3.5143967942433987`*^9, 3.514396846703472*^9}, {
   3.514396893313537*^9, 3.514396975353652*^9}, {3.5143980891823254`*^9, 
   3.5143981015520325`*^9}, {3.5143981687648773`*^9, 
   3.5143981710610085`*^9}, {3.514399891780428*^9, 3.514399893544529*^9}, {
   3.5144000287872643`*^9, 3.5144000331475134`*^9}, {3.51485465909291*^9, 
   3.5148546600289116`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{" ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{
       SuperscriptBox[
        SqrtBox[
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"]], "j"], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{
         RowBox[{"j", " ", "m"}], "-", 
         RowBox[{"3", "/", "2"}]}]], 
       RowBox[{"(", " ", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}], 
      SqrtBox[
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5142247663462954`*^9, 
   3.5142248021639585`*^9}, {3.514253761668475*^9, 3.514253785538509*^9}, {
   3.514253853498604*^9, 3.514253870598628*^9}, {3.5142539471187353`*^9, 
   3.5142540442288713`*^9}, {3.514256942172928*^9, 3.5142569660829616`*^9}, {
   3.5143958129420247`*^9, 3.514395822802038*^9}, {3.5143963480027733`*^9, 
   3.514396363392795*^9}, 3.514396471892947*^9, {3.5143965757730923`*^9, 
   3.5143965997731256`*^9}, {3.5143966406231833`*^9, 3.514396655623204*^9}, {
   3.5143971490038953`*^9, 3.5143971789939375`*^9}, 3.5143983745536475`*^9, {
   3.5143984240344777`*^9, 3.5143984320289345`*^9}, {3.5143995617325506`*^9, 
   3.514399613639519*^9}, {3.5143997213486795`*^9, 3.514399797742049*^9}, {
   3.515189786935784*^9, 3.5151897932057924`*^9}, {3.515189826335839*^9, 
   3.5151898303258443`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}], "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", "\n", "    ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^",
          "j"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "-", 
           RowBox[{"3", "/", "2"}]}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"C", "+", 
           RowBox[{"B", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"A", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "m"}], "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, 3.5142223995725384`*^9, {3.5142249275881786`*^9, 
   3.5142249458246107`*^9}, 3.514225230603111*^9, {3.5142290392362003`*^9, 
   3.5142290573946323`*^9}, 3.5142538004285297`*^9, {3.5142542521991625`*^9, 
   3.5142542532391634`*^9}, {3.514254291249217*^9, 3.5142544290794096`*^9}, {
   3.5142583832749453`*^9, 3.5142584292150097`*^9}, {3.5143958450020695`*^9, 
   3.5143958674421005`*^9}, {3.5143960423023453`*^9, 3.514396074522391*^9}, {
   3.514396122022457*^9, 3.5143961313624706`*^9}, {3.5143961632325153`*^9, 
   3.5143961760225325`*^9}, {3.5143967449833293`*^9, 3.514396779623378*^9}, {
   3.514396986183667*^9, 3.5143970626537743`*^9}, {3.5143972878540897`*^9, 
   3.514397354094182*^9}, {3.514397455514324*^9, 3.514397455794325*^9}, {
   3.514398071185296*^9, 3.5143980807958455`*^9}, {3.5143981737481623`*^9, 
   3.5143981755572653`*^9}, 3.514398435679144*^9, {3.514398565559572*^9, 
   3.5143985929341383`*^9}, 3.51439862478296*^9, {3.514399904460153*^9, 
   3.5143999346578803`*^9}, {3.5143999984205275`*^9, 3.514400016508562*^9}, {
   3.5144000869565916`*^9, 3.5144001419097347`*^9}, {3.514400173178523*^9, 
   3.514400173629549*^9}, {3.5144008219306297`*^9, 3.5144008262558765`*^9}, 
   3.514401418368744*^9, {3.5159796084639*^9, 3.5159796098523026`*^9}, 
   3.516821073217046*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^",
          "j"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "-", 
           RowBox[{"3", "/", "2"}]}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"C", "+", 
           RowBox[{"A", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "m"}], "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, 3.5142223995725384`*^9, {3.5142249275881786`*^9, 
   3.5142249458246107`*^9}, 3.514225230603111*^9, {3.5142290392362003`*^9, 
   3.5142290573946323`*^9}, 3.5142538004285297`*^9, {3.5142542521991625`*^9, 
   3.5142542532391634`*^9}, {3.514254291249217*^9, 3.5142544290794096`*^9}, {
   3.5142583832749453`*^9, 3.5142584292150097`*^9}, {3.5143958450020695`*^9, 
   3.5143958674421005`*^9}, {3.5143960423023453`*^9, 3.514396074522391*^9}, {
   3.514396122022457*^9, 3.5143961313624706`*^9}, {3.5143961632325153`*^9, 
   3.5143961760225325`*^9}, {3.5143967449833293`*^9, 3.514396779623378*^9}, {
   3.514396986183667*^9, 3.5143970626537743`*^9}, {3.5143972878540897`*^9, 
   3.514397354094182*^9}, {3.514397455514324*^9, 3.514397455794325*^9}, {
   3.514398071185296*^9, 3.5143980807958455`*^9}, {3.5143981737481623`*^9, 
   3.5143981755572653`*^9}, 3.514398435679144*^9, {3.514398565559572*^9, 
   3.5143985929341383`*^9}, 3.51439862478296*^9, {3.514399904460153*^9, 
   3.5143999346578803`*^9}, {3.5143999984205275`*^9, 3.514400016508562*^9}, {
   3.5144000869565916`*^9, 3.5144001810149713`*^9}, 3.5144008489031725`*^9, 
   3.5144014228550005`*^9, 3.5168210732370453`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["j",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.5107886589272957`*^9, 3.5107886636973023`*^9}, {3.513133819679427*^9, 
   3.5131338265494366`*^9}, {3.5148545486759157`*^9, 3.514854555477528*^9}, {
   3.515189846965868*^9, 3.515189863315891*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "m"], 
      SuperscriptBox[
       RowBox[{"Csc", "[", "z", "]"}], "m"]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5107881322665586`*^9, 3.5107881705866117`*^9}, {3.510788449847003*^9, 
   3.510788449847003*^9}, {3.5131325965637026`*^9, 3.5131325965637026`*^9}, {
   3.5131326285737476`*^9, 3.5131326291037483`*^9}}],

Cell[TextData[{
 "Rule j: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"0", "<", "m", "<", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510792844771161*^9, 3.510792845691162*^9}, {
   3.5108461760802317`*^9, 3.5108461760802317`*^9}, {3.5131324316734715`*^9, 
   3.5131324335234747`*^9}, {3.513134327160137*^9, 3.513134341790158*^9}, 
   3.513134515600401*^9, {3.513136963900999*^9, 3.5131369653310013`*^9}, {
   3.5148546713233314`*^9, 3.514854672228133*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], " ", 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107887441574154`*^9, 3.5107887467174187`*^9}, 
   3.5108457922571573`*^9, {3.5131323613533735`*^9, 3.5131323778533964`*^9}, {
   3.513132420543456*^9, 3.513132420753456*^9}, {3.515189850835873*^9, 
   3.5151898680858974`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107887756674595`*^9, 
   3.5107888160375156`*^9}, {3.5107888710675926`*^9, 
   3.5107888724475946`*^9}, {3.5107889881877565`*^9, 3.510788989037758*^9}, {
   3.5107928401111546`*^9, 3.510792841351156*^9}, 3.5108457831935415`*^9, {
   3.510846001328725*^9, 3.510846064976836*^9}, {3.513131395797769*^9, 
   3.513131399357774*^9}, 3.5131323576833677`*^9, {3.5131323906034145`*^9, 
   3.513132417463452*^9}, {3.5131325388836217`*^9, 3.513132546123632*^9}, {
   3.5131325769336753`*^9, 3.5131325801636796`*^9}, {3.5131331771845245`*^9, 
   3.5131331862945375`*^9}, {3.5131332889746814`*^9, 
   3.5131332972246933`*^9}, {3.5131335146549973`*^9, 
   3.5131335296350183`*^9}, {3.513133661945204*^9, 3.513133678455227*^9}, {
   3.5131339717796397`*^9, 3.5131339953896728`*^9}, {3.513134136819871*^9, 
   3.513134142779879*^9}, {3.513134194099951*^9, 3.513134228389999*^9}, 
   3.513135208281024*^9, {3.5159796813628283`*^9, 3.51597968248603*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107887756674595`*^9, 
   3.5107888160375156`*^9}, {3.5107888710675926`*^9, 
   3.5107888724475946`*^9}, {3.5107889881877565`*^9, 3.510788989037758*^9}, {
   3.5107928401111546`*^9, 3.510792841351156*^9}, 3.5108457831935415`*^9, {
   3.510846001328725*^9, 3.510846064976836*^9}, {3.513131395797769*^9, 
   3.513131399357774*^9}, 3.5131323576833677`*^9, {3.5131323906034145`*^9, 
   3.513132417463452*^9}, {3.5131325388836217`*^9, 3.513132546123632*^9}, {
   3.5131325769336753`*^9, 3.5131325801636796`*^9}, {3.5131331771845245`*^9, 
   3.5131331862945375`*^9}, {3.5131332889746814`*^9, 
   3.5131332972246933`*^9}, {3.5131335146549973`*^9, 
   3.5131335296350183`*^9}, {3.513133661945204*^9, 3.513133678455227*^9}, {
   3.5131339717796397`*^9, 3.5131339953896728`*^9}, {3.513134136819871*^9, 
   3.513134142779879*^9}, {3.513134194099951*^9, 3.513134228389999*^9}, {
   3.5131344005002403`*^9, 3.5131344107402544`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "9"}], "-", "10"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, {
   3.5120748195044174`*^9, 3.5120748357644405`*^9}, 3.514641587297715*^9, {
   3.515189444375304*^9, 3.5151894460053062`*^9}, {3.516564136677558*^9, 
   3.5165641392875614`*^9}, 3.5165648319082274`*^9, {3.5165898962383423`*^9, 
   3.5165898987983465`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 1 with ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.505345104484432*^9, 
   3.505345123354459*^9}, {3.5057058835492005`*^9, 3.5057058890792084`*^9}, {
   3.5094820888781176`*^9, 3.5094820947444534`*^9}, 3.5120745389640245`*^9, 
   3.514161770227974*^9, 3.51464892969836*^9, {3.5165647309016504`*^9, 
   3.5165647341464562`*^9}}],

Cell[TextData[{
 "Rule 9: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], "A"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
     " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026766235607233`*^9, 3.502676653910766*^9}, {
   3.5026767649609213`*^9, 3.502676774560935*^9}, {3.5027672387222033`*^9, 
   3.5027672432618113`*^9}, {3.503549718271271*^9, 3.5035497401413016`*^9}, {
   3.504028628528908*^9, 3.504028628903309*^9}, {3.5040318440957556`*^9, 
   3.5040318489317646`*^9}, 3.5043107424584675`*^9, 3.504750503056654*^9, {
   3.509240781672722*^9, 3.5092407958531466`*^9}, {3.5094792332377844`*^9, 
   3.5094792342168407`*^9}, {3.5094793524296017`*^9, 
   3.5094793545107207`*^9}, {3.509480690341126*^9, 3.509480692496249*^9}, {
   3.5094823892893004`*^9, 3.509482390550372*^9}, {3.5099361428088536`*^9, 
   3.5099361433688545`*^9}, {3.510505173363065*^9, 3.5105051737842655`*^9}, {
   3.5114608103187995`*^9, 3.5114608109988003`*^9}, {3.5120748388444443`*^9, 
   3.512074839664446*^9}, 3.514614908818122*^9, {3.5146496332751956`*^9, 
   3.5146496378616037`*^9}, {3.5146601061679506`*^9, 3.514660106407951*^9}, {
   3.516564255177724*^9, 3.5165642557477245`*^9}, 3.5165647754997287`*^9, 
   3.51658990138835*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}], "+", 
          RowBox[{"a", " ", "C"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C"}], "-", 
          RowBox[{"a", " ", "b", " ", "B"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "A"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["b", "2"], "A"}], "-", 
             RowBox[{"a", " ", "b", " ", "B"}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", "C"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.5101615196270494`*^9, 3.5101615236518564`*^9}, {3.510161654707687*^9, 
   3.5101616568604903`*^9}, {3.5101619292841697`*^9, 3.510161930812972*^9}, {
   3.510161988657874*^9, 3.5101619894222755`*^9}, {3.5151898848059206`*^9, 
   3.515189886945924*^9}, {3.5165643357978363`*^9, 3.5165643884979105`*^9}, {
   3.516564434357974*^9, 3.516564521108096*^9}, {3.516564601038223*^9, 
   3.5165646230342617`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
        RowBox[{"a", "*", "b", "*", "B"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}], "+", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
               RowBox[{"a", "*", "b", "*", "B"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}], "-", 
                  RowBox[{"a", "*", "b", "*", "B"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.5146606628987293`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "b", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, {
   3.509500883598176*^9, 3.5095008878881836`*^9}, {3.509501037929247*^9, 
   3.509501082607725*^9}, 3.509902934903042*^9, 3.5104336424519887`*^9, 
   3.5105129585579395`*^9, 3.5112297430504093`*^9, 3.511230357005088*^9, {
   3.5114608833189015`*^9, 3.5114608843389034`*^9}, 3.5118126175255213`*^9, 
   3.514474504079243*^9, {3.5146495864283133`*^9, 3.514649597036332*^9}, 
   3.514660667268736*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
        RowBox[{"a", "*", "b", "*", "B"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}], "+", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
               RowBox[{"a", "*", "b", "*", "B"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}], "-", 
                  RowBox[{"a", "*", "b", "*", "B"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.5146606628987293`*^9, {3.516565380092388*^9, 
   3.5165654632881336`*^9}, {3.516565847109607*^9, 3.51656585444162*^9}, {
   3.5165661900246086`*^9, 3.5165661912570105`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "b", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.5146606628987293`*^9, {3.516565380092388*^9, 
   3.5165654632881336`*^9}, {3.516565847109607*^9, 3.51656585444162*^9}, {
   3.5165660751496077`*^9, 3.5165660976916475`*^9}, {3.5165661414841237`*^9, 
   3.5165661674113693`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 2 with ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.5017304653801064`*^9, 3.501730494037357*^9}, {3.501730604179551*^9, 
   3.5017306171587734`*^9}, {3.5034185653536963`*^9, 
   3.5034185683937006`*^9}, {3.5034226237593784`*^9, 3.5034226290093856`*^9}, 
   3.5053451044944324`*^9, {3.509482100959809*^9, 3.509482110306343*^9}, 
   3.5120745501540403`*^9, 3.5141617710379753`*^9, 3.5146489464527893`*^9, 
   3.5165648188978043`*^9, {3.516564852032263*^9, 3.516564854543867*^9}}],

Cell[TextData[{
 "Rule 10: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.503421192847375*^9, 3.503421192847375*^9}, {
   3.5034383255889688`*^9, 3.5034383282289724`*^9}, {3.504331822596939*^9, 
   3.5043318234969406`*^9}, {3.504988941601285*^9, 3.504988942181286*^9}, 
   3.5087861934230595`*^9, 3.509482964630208*^9, {3.509936156008872*^9, 
   3.5099361567288733`*^9}, {3.510505182442281*^9, 3.510505183128682*^9}, {
   3.512074844314452*^9, 3.5120748451244535`*^9}, 3.514614982497452*^9, {
   3.514641288021989*^9, 3.514641289753592*^9}, {3.5146414380210533`*^9, 
   3.514641438286254*^9}, {3.514652945017925*^9, 3.514652945327925*^9}, {
   3.5165642587977285`*^9, 3.5165642592877293`*^9}, 3.516564792622958*^9, {
   3.5165899054683557`*^9, 3.5165899061283565`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "A", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], "+", 
       RowBox[{"b", " ", "C", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}], "-", 
          RowBox[{"a", " ", "C"}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5101642321454153`*^9, 3.5101642363106227`*^9}, {
   3.5101642797722993`*^9, 3.5101643150283613`*^9}, {3.5101646049236703`*^9, 
   3.5101646129576845`*^9}, {3.5151898918659306`*^9, 
   3.5151898944059343`*^9}, {3.5165648897831287`*^9, 3.516564962825657*^9}, {
   3.516565006535733*^9, 3.516565084796671*^9}, {3.5165651268107443`*^9, 
   3.5165651388851657`*^9}, 3.5165651693052187`*^9, {3.516565336786712*^9, 
   3.516565347659931*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}]}], "+", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "2"}], ")"}]}], "-", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509481784211692*^9, {3.5094818179926243`*^9, 3.5094818327964706`*^9}, 
   3.5094819101238937`*^9, {3.5094828616743193`*^9, 3.5094828762901554`*^9}, 
   3.5098964710997996`*^9, {3.510504660652564*^9, 3.5105046611829653`*^9}, {
   3.5105160467861633`*^9, 3.510516049001367*^9}, 3.5118083030934734`*^9, 
   3.5144744283131104`*^9, {3.5146412598015394`*^9, 3.514641261969943*^9}, {
   3.5146414410006585`*^9, 3.5146414416090593`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}]}], "+", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{"a", "*", "C", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509481784211692*^9, {3.5094818179926243`*^9, 3.5094818327964706`*^9}, 
   3.5094819101238937`*^9, {3.5094828616743193`*^9, 3.5094828762901554`*^9}, {
   3.5095009118966255`*^9, 3.5095009151726313`*^9}, {3.5095011942103214`*^9, 
   3.5095011981883287`*^9}, 3.509902928363033*^9, 3.510433645711993*^9, {
   3.510504679949798*^9, 3.5105046803865986`*^9}, 3.5105140239930105`*^9, {
   3.5105160917454424`*^9, 3.5105160935238457`*^9}, 3.5112297393220034`*^9, 
   3.5112304822421083`*^9, {3.511230535360201*^9, 3.5112305878386936`*^9}, 
   3.511230817148297*^9, 3.5118126133055153`*^9, 3.5144744155522876`*^9, {
   3.514641282249979*^9, 3.514641284355983*^9}, {3.514641443871063*^9, 
   3.5146414444014645`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}]}], "+", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "2"}], ")"}]}], "-", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509481784211692*^9, {3.5094818179926243`*^9, 3.5094818327964706`*^9}, 
   3.5094819101238937`*^9, {3.5094828616743193`*^9, 3.5094828762901554`*^9}, 
   3.5098964710997996`*^9, {3.510504660652564*^9, 3.5105046611829653`*^9}, {
   3.5105160467861633`*^9, 3.510516049001367*^9}, 3.5118083030934734`*^9, 
   3.5144744283131104`*^9, {3.5146412598015394`*^9, 3.514641261969943*^9}, {
   3.5146414410006585`*^9, 3.5146414416090593`*^9}, {3.516566306478813*^9, 
   3.516566363403313*^9}, 3.5165694184076586`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", "\n", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "2"}], ")"}]}], "+", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{"a", "*", "C", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509481784211692*^9, {3.5094818179926243`*^9, 3.5094818327964706`*^9}, 
   3.5094819101238937`*^9, {3.5094828616743193`*^9, 3.5094828762901554`*^9}, 
   3.5098964710997996`*^9, {3.510504660652564*^9, 3.5105046611829653`*^9}, {
   3.5105160467861633`*^9, 3.510516049001367*^9}, 3.5118083030934734`*^9, 
   3.5144744283131104`*^9, {3.5146412598015394`*^9, 3.514641261969943*^9}, {
   3.5146414410006585`*^9, 3.5146414416090593`*^9}, {3.516566306478813*^9, 
   3.516566363403313*^9}, {3.516566447690261*^9, 3.5165664898259354`*^9}, 
   3.5165694219676633`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "11"}], "-", "12"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511617733184*^9, 3.510511622272792*^9}, {
   3.5120748195044174`*^9, 3.5120748357644405`*^9}, 3.514641587297715*^9, {
   3.515189444375304*^9, 3.5151894460053062`*^9}, {3.516564136677558*^9, 
   3.5165641392875614`*^9}, 3.5165648319082274`*^9, {3.5165898962383423`*^9, 
   3.5165898987983465`*^9}, {3.517001464527277*^9, 3.5170014734972925`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["\<\
Note: The rules in this section would only generate slightly simpler \
antiderivatives and require as many steps as using rules 3 and 4 directly.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.505345104484432*^9, 
   3.505345123354459*^9}, {3.5057058835492005`*^9, 3.5057058890792084`*^9}, {
   3.5094820888781176`*^9, 3.5094820947444534`*^9}, 3.5120745389640245`*^9, 
   3.514161770227974*^9, 3.51464892969836*^9, {3.5165647309016504`*^9, 
   3.5165647341464562`*^9}, {3.517001646205196*^9, 3.517001647047598*^9}, {
   3.517005394527382*^9, 3.5170054106110106`*^9}, {3.5170054754135237`*^9, 
   3.5170055171279974`*^9}, {3.5170077333878913`*^9, 3.517007825630853*^9}, {
   3.517007910292202*^9, 3.517007967700303*^9}, {3.5170720869167047`*^9, 
   3.517072091081912*^9}}],

Cell[TextData[{
 "Derivation: Rule 4 with ",
 Cell[BoxData[
  RowBox[{"n", "=", "1"}]]],
 " and ???"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.505345104484432*^9, 
   3.505345123354459*^9}, {3.5057058835492005`*^9, 3.5057058890792084`*^9}, {
   3.5094820888781176`*^9, 3.5094820947444534`*^9}, 3.5120745389640245`*^9, 
   3.514161770227974*^9, 3.51464892969836*^9, {3.5165647309016504`*^9, 
   3.5165647341464562`*^9}, {3.517001646205196*^9, 3.517001647047598*^9}, {
   3.517005394527382*^9, 3.5170054106110106`*^9}, {3.5170054754135237`*^9, 
   3.5170055171279974`*^9}}],

Cell[TextData[{
 "Rule 11: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026766235607233`*^9, 3.502676653910766*^9}, {
   3.5026767649609213`*^9, 3.502676774560935*^9}, {3.5027672387222033`*^9, 
   3.5027672432618113`*^9}, {3.503549718271271*^9, 3.5035497401413016`*^9}, {
   3.504028628528908*^9, 3.504028628903309*^9}, {3.5040318440957556`*^9, 
   3.5040318489317646`*^9}, 3.5043107424584675`*^9, 3.504750503056654*^9, {
   3.509240781672722*^9, 3.5092407958531466`*^9}, {3.5094792332377844`*^9, 
   3.5094792342168407`*^9}, {3.5094793524296017`*^9, 
   3.5094793545107207`*^9}, {3.509480690341126*^9, 3.509480692496249*^9}, {
   3.5094823892893004`*^9, 3.509482390550372*^9}, {3.5099361428088536`*^9, 
   3.5099361433688545`*^9}, {3.510505173363065*^9, 3.5105051737842655`*^9}, {
   3.5114608103187995`*^9, 3.5114608109988003`*^9}, {3.5120748388444443`*^9, 
   3.512074839664446*^9}, 3.514614908818122*^9, {3.5146496332751956`*^9, 
   3.5146496378616037`*^9}, {3.5146601061679506`*^9, 3.514660106407951*^9}, {
   3.516564255177724*^9, 3.5165642557477245`*^9}, 3.5165647754997287`*^9, 
   3.51658990138835*^9, 3.5170016725848427`*^9, {3.5170017541261854`*^9, 
   3.517001783189037*^9}, {3.517001821019103*^9, 3.5170018494579535`*^9}, {
   3.5170024352961826`*^9, 3.517002435498983*^9}, {3.517072472174981*^9, 
   3.5170725161670585`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", " ", "A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "+", 
           RowBox[{"a", " ", "B"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "3"}], "2"]}], ")"}], " ", "a", " ", "A"}], 
           "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "B"}], "+", 
              RowBox[{"a", " ", "C"}]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}], " ", "b", " ", "C", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.5101615196270494`*^9, 3.5101615236518564`*^9}, {3.510161654707687*^9, 
   3.5101616568604903`*^9}, {3.5101619292841697`*^9, 3.510161930812972*^9}, {
   3.510161988657874*^9, 3.5101619894222755`*^9}, {3.5151898848059206`*^9, 
   3.515189886945924*^9}, {3.5165643357978363`*^9, 3.5165643884979105`*^9}, {
   3.516564434357974*^9, 3.516564521108096*^9}, {3.516564601038223*^9, 
   3.5165646230342617`*^9}, {3.517001532309396*^9, 3.517001567612258*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
       "m_."}], "*", 
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*",
       "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", "A", "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"d", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}],
      " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
       "\[IndentingNewLine]", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "+", 
             RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
          "      ", 
          RowBox[{"Sim", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"b", "*", "A"}], "+", 
                RowBox[{"a", "*", "B"}]}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 "a", "*", "A"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"b", "*", "B"}], "+", 
                   RowBox[{"a", "*", "C"}]}], ")"}]}]}], ")"}], "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
             "\[IndentingNewLine]", "        ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
              "b", "*", "C", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}]}], 
         ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"OneQ", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], ",", 
       RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"k2", "===", 
      RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "<", 
      RowBox[{"-", "1"}]}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.5146606628987293`*^9, {3.5170016983560877`*^9, 
   3.517001713893715*^9}, {3.517001879659606*^9, 3.517001883590813*^9}, {
   3.51700195023413*^9, 3.517001973368971*^9}, {3.51700201261864*^9, 
   3.517002038623885*^9}, {3.5170021053140025`*^9, 3.517002110789612*^9}, {
   3.5170022575078697`*^9, 3.5170022942875347`*^9}, {3.5170078507936974`*^9, 
   3.5170078546001043`*^9}, {3.5170721097083445`*^9, 
   3.5170721112527475`*^9}, {3.5170721493792143`*^9, 3.517072154199623*^9}, {
   3.517072195617696*^9, 3.5170721975832987`*^9}, 3.517072438260522*^9, {
   3.5170725268842773`*^9, 3.517072528038679*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
       "m_."}], "*", 
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*",
       "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "*", "A", "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"d", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}],
      " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
       "\[IndentingNewLine]", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "+", 
             RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
          "      ", 
          RowBox[{"Sim", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
              "b", "*", "A"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 "a", "*", "A"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 "a", "*", "C"}]}], ")"}], "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
             "\[IndentingNewLine]", "        ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
              "b", "*", "C", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}]}], 
         ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"OneQ", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], ",", 
       RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"k2", "===", 
      RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "<", 
      RowBox[{"-", "1"}]}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.509480699247636*^9, 3.5094807001776886`*^9}, {
   3.509481029697536*^9, 3.509481029902548*^9}, {3.5094811407088857`*^9, 
   3.509481160623025*^9}, {3.5094825690095797`*^9, 3.5094826005283823`*^9}, 
   3.5098966309844804`*^9, {3.511460805978793*^9, 3.5114608069587946`*^9}, 
   3.5118083077734804`*^9, 3.5144745072304487`*^9, {3.514649548645047*^9, 
   3.514649558176664*^9}, 3.5146606628987293`*^9, {3.5170016983560877`*^9, 
   3.517001713893715*^9}, {3.517001879659606*^9, 3.517001883590813*^9}, {
   3.51700195023413*^9, 3.517001973368971*^9}, {3.51700201261864*^9, 
   3.517002038623885*^9}, {3.5170021053140025`*^9, 3.517002110789612*^9}, {
   3.5170022575078697`*^9, 3.5170022942875347`*^9}, {3.517005134521725*^9, 
   3.517005156673764*^9}, {3.517007856971308*^9, 3.5170078611677155`*^9}, {
   3.5170721157143555`*^9, 3.517072117227558*^9}, {3.5170722218101416`*^9, 
   3.517072291838664*^9}, {3.5170723262055244`*^9, 3.5170723482483635`*^9}, 
   3.517072435046916*^9, {3.5170725327498875`*^9, 3.5170725336858892`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3 with ",
 Cell[BoxData[
  RowBox[{"n", "=", "1"}]]],
 " and ???"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.504317709628769*^9, 3.5043177230887876`*^9}, {3.505345104484432*^9, 
   3.505345123354459*^9}, {3.5057058835492005`*^9, 3.5057058890792084`*^9}, {
   3.5094820888781176`*^9, 3.5094820947444534`*^9}, 3.5120745389640245`*^9, 
   3.514161770227974*^9, 3.51464892969836*^9, {3.5165647309016504`*^9, 
   3.5165647341464562`*^9}, {3.517001646205196*^9, 3.517001647047598*^9}, {
   3.517005394527382*^9, 3.5170054106110106`*^9}, {3.517005521402405*^9, 
   3.517005523258808*^9}}],

Cell[TextData[{
 "Rule 12: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.503421192847375*^9, 3.503421192847375*^9}, {
   3.5034383255889688`*^9, 3.5034383282289724`*^9}, {3.504331822596939*^9, 
   3.5043318234969406`*^9}, {3.504988941601285*^9, 3.504988942181286*^9}, 
   3.5087861934230595`*^9, 3.509482964630208*^9, {3.509936156008872*^9, 
   3.5099361567288733`*^9}, {3.510505182442281*^9, 3.510505183128682*^9}, {
   3.512074844314452*^9, 3.5120748451244535`*^9}, 3.514614982497452*^9, {
   3.514641288021989*^9, 3.514641289753592*^9}, {3.5146414380210533`*^9, 
   3.514641438286254*^9}, {3.514652945017925*^9, 3.514652945327925*^9}, {
   3.5165642587977285`*^9, 3.5165642592877293`*^9}, 3.516564792622958*^9, {
   3.5165899054683557`*^9, 3.5165899061283565`*^9}, 3.517001679558055*^9, {
   3.5170024373397865`*^9, 3.517002451582611*^9}, {3.5170724771201897`*^9, 
   3.51707247730739*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"2", "j", " ", "k"}]}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "5"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "5"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "5"}], "2"]}], ")"}], " ", "a", " ", "A"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "5"}], "2"]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "3"}], "2"]}], ")"}], "b", " ", "C"}]}], 
          ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "5"}], "2"]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B"}], "+", 
           RowBox[{"a", " ", "C"}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5101642321454153`*^9, 3.5101642363106227`*^9}, {
   3.5101642797722993`*^9, 3.5101643150283613`*^9}, {3.5101646049236703`*^9, 
   3.5101646129576845`*^9}, {3.5151898918659306`*^9, 
   3.5151898944059343`*^9}, {3.5165648897831287`*^9, 3.516564962825657*^9}, {
   3.516565006535733*^9, 3.516565084796671*^9}, {3.5165651268107443`*^9, 
   3.5165651388851657`*^9}, 3.5165651693052187`*^9, {3.516565336786712*^9, 
   3.516565347659931*^9}, {3.5170015916675005`*^9, 3.5170016202467504`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
       "m_."}], "*", 
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*",
       "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], "*", "C", "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"d", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}],
      " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
       "\[IndentingNewLine]", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
           "m"}], "*", "\[IndentingNewLine]", "      ", 
          RowBox[{"Sim", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}], "*", 
              "a", "*", "A"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"b", "*", "A"}], "+", 
                   RowBox[{"a", "*", "B"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 "b", "*", "C"}]}], ")"}], "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
             "\[IndentingNewLine]", "        ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"b", "*", "B"}], "+", 
                RowBox[{"a", "*", "C"}]}], ")"}], "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}]}], 
         ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"OneQ", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], ",", 
       RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"k2", "===", 
      RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509481784211692*^9, {3.5094818179926243`*^9, 3.5094818327964706`*^9}, 
   3.5094819101238937`*^9, {3.5094828616743193`*^9, 3.5094828762901554`*^9}, 
   3.5098964710997996`*^9, {3.510504660652564*^9, 3.5105046611829653`*^9}, {
   3.5105160467861633`*^9, 3.510516049001367*^9}, 3.5118083030934734`*^9, 
   3.5144744283131104`*^9, {3.5146412598015394`*^9, 3.514641261969943*^9}, {
   3.5146414410006585`*^9, 3.5146414416090593`*^9}, {3.5170017175753217`*^9, 
   3.517001718729724*^9}, 3.517001952886135*^9, {3.5170020525391097`*^9, 
   3.517002063521529*^9}, {3.517002129899646*^9, 3.517002133581252*^9}, {
   3.5170024102113385`*^9, 3.517002420694557*^9}, {3.5170078671893263`*^9, 
   3.5170078709177327`*^9}, {3.5170721237639694`*^9, 3.517072125308372*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
       "m_."}], "*", 
      RowBox[{"(", 
       RowBox[{"A_.", "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*",
       "\n", "    ", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], "*", "C", "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"d", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}],
      " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
       "\[IndentingNewLine]", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
           "m"}], "*", "\[IndentingNewLine]", "      ", 
          RowBox[{"Sim", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}], "*", 
              "a", "*", "A"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 "b", "*", "A"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"j", "*", "k", "*", "m"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
                 "b", "*", "C"}]}], ")"}], "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
             "\[IndentingNewLine]", "        ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"j", "*", "k", "*", "m"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"k", "+", "5"}], ")"}], "/", "2"}]}], ")"}], "*", 
              "a", "*", "C", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}]}], 
         ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"OneQ", "[", 
      RowBox[{
       RowBox[{"j", "^", "2"}], ",", 
       RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"k2", "===", 
      RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.509481784211692*^9, {3.5094818179926243`*^9, 3.5094818327964706`*^9}, 
   3.5094819101238937`*^9, {3.5094828616743193`*^9, 3.5094828762901554`*^9}, 
   3.5098964710997996`*^9, {3.510504660652564*^9, 3.5105046611829653`*^9}, {
   3.5105160467861633`*^9, 3.510516049001367*^9}, 3.5118083030934734`*^9, 
   3.5144744283131104`*^9, {3.5146412598015394`*^9, 3.514641261969943*^9}, {
   3.5146414410006585`*^9, 3.5146414416090593`*^9}, {3.5170017175753217`*^9, 
   3.517001718729724*^9}, 3.517001952886135*^9, {3.5170020525391097`*^9, 
   3.517002063521529*^9}, {3.517002129899646*^9, 3.517002133581252*^9}, {
   3.5170024102113385`*^9, 3.517002420694557*^9}, {3.5170051911186247`*^9, 
   3.517005208965056*^9}, {3.517007874614939*^9, 3.517007878904947*^9}, {
   3.5170721282255774`*^9, 3.51707212981678*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "1"}], "-", "6"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.5111157822916574`*^9, {3.51207475723433*^9, 
   3.5120747639343395`*^9}, {3.5151898768459096`*^9, 3.515189877975911*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 1 or 6 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "C"}], "-", 
    RowBox[{"a", " ", "b", " ", "B"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "A"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.50267628508025*^9, 3.5026762853502502`*^9}, {
   3.504031783052849*^9, 3.504031790244461*^9}, 3.505345087634409*^9, 
   3.512074540034026*^9, {3.5144121659594707`*^9, 3.514412173711914*^9}, {
   3.514412476078209*^9, 3.5144124771672707`*^9}}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017237232810616`*^9, 3.5017237250750647`*^9}, {
   3.5027664855216804`*^9, 3.5027664896088877`*^9}}],

Cell[TextData[{
 "Basis:  If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "C"}], "-", 
    RowBox[{"a", " ", "b", " ", "B"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "A"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"A", "+", 
    RowBox[{"B", " ", "z"}], "+", 
    RowBox[{"C", " ", 
     SuperscriptBox["z", "2"]}]}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B"}], "-", 
       RowBox[{"a", " ", "C"}], "+", 
       RowBox[{"b", " ", "C", " ", "z"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}]}], 
    SuperscriptBox["b", "2"]]}]], "Input",
  CellChangeTimes->{{3.5027666870896344`*^9, 3.502766694577647*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017237232810616`*^9, 3.5017237250750647`*^9}, {
   3.5027664855216804`*^9, 3.5027664896088877`*^9}, {3.5027665557998037`*^9, 
   3.5027665566110053`*^9}, 3.5027665996046805`*^9, {3.502766706511668*^9, 
   3.5027667557297544`*^9}, 3.502767181048902*^9, {3.502767342353185*^9, 
   3.5027673502359996`*^9}, 3.502767478140624*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "C"}], "-", 
       RowBox[{"a", " ", "b", " ", "B"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "A"}]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"n", "<", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.501358653573163*^9, 3.5013586559531665`*^9}, {
   3.502678432393256*^9, 3.5026784351732597`*^9}, {3.502766589293062*^9, 
   3.502766589293062*^9}, 3.5027671790052986`*^9, 3.5027674748646183`*^9, {
   3.5038569856949825`*^9, 3.503856992059794*^9}, {3.504031357905302*^9, 
   3.5040313587633038`*^9}, 3.5040317449575815`*^9, {3.504311260541732*^9, 
   3.504311260711732*^9}, {3.504750498076647*^9, 3.50475050021665*^9}, {
   3.5092408217803926`*^9, 3.509240824151596*^9}, {3.510164009908225*^9, 
   3.510164009908225*^9}, {3.5117214107451816`*^9, 3.5117214107451816`*^9}, {
   3.5120768665233393`*^9, 3.5120768665233393`*^9}, {3.5121850888428593`*^9, 
   3.5121850938972683`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox["1", 
      SuperscriptBox["b", "2"]]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "B"}], "-", 
       RowBox[{"a", " ", "C"}], "+", 
       RowBox[{"b", " ", "C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, {3.5027658915998363`*^9, 3.502765896981846*^9}, {
   3.5027668222170715`*^9, 3.50276686143554*^9}, {3.505344692893856*^9, 
   3.5053446929038563`*^9}, {3.5092397382492895`*^9, 
   3.5092398121778193`*^9}, {3.51016418932094*^9, 3.5101642175257893`*^9}, {
   3.515189878545912*^9, 3.515189880095914*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", "2"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sim", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "*", "B"}], "-", 
           RowBox[{"a", "*", "C"}], "+", 
           RowBox[{"b", "*", "C", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
         "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, 
   3.50052634660607*^9, {3.501043281866661*^9, 3.5010432838407745`*^9}, {
   3.501358610383103*^9, 3.5013586217531185`*^9}, {3.5026774770619183`*^9, 
   3.5026774832519274`*^9}, {3.502677757052311*^9, 3.502677762832319*^9}, {
   3.502765679626664*^9, 3.502765694945891*^9}, {3.502766916862438*^9, 
   3.5027669304188614`*^9}, 3.5027671021907635`*^9, {3.503071895268139*^9, 
   3.5030719155981674`*^9}, {3.50351615772817*^9, 3.5035161598181725`*^9}, {
   3.503856818447089*^9, 3.503856835341919*^9}, {3.5053446929138565`*^9, 
   3.5053446929338565`*^9}, {3.5092398129578204`*^9, 
   3.5092399297864256`*^9}, {3.509240858050456*^9, 3.509240876630089*^9}, {
   3.5094733331253176`*^9, 3.509473337703579*^9}, 3.509475176411747*^9, 
   3.5094752858760085`*^9, 3.5099379677634096`*^9, 3.5099380908635817`*^9, {
   3.510162512862395*^9, 3.5101625133303957`*^9}, {3.510164194515749*^9, 
   3.5101642104433775`*^9}, 3.5101666942815046`*^9, {3.5120759144259744`*^9, 
   3.512075914615975*^9}, {3.5159797216064987`*^9, 3.515979724586104*^9}, 
   3.5168207803566356`*^9, {3.517001932668499*^9, 3.5170019351801033`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", "2"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sim", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "*", "C"}], "+", 
           RowBox[{"b", "*", "C", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
         "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.4993638009881725`*^9, {3.4993661760314975`*^9, 3.4993661794315023`*^9}, 
   3.4993699436547995`*^9, 3.499369995914872*^9, {3.5003179814609165`*^9, 
   3.5003179817417173`*^9}, 3.5003186747732515`*^9, {3.5003187057132945`*^9, 
   3.5003187115933027`*^9}, {3.5003194495843363`*^9, 3.500319453664342*^9}, {
   3.5003198135348454`*^9, 3.5003198411248837`*^9}, 3.500320756016165*^9, 
   3.50052634660607*^9, {3.501043281866661*^9, 3.5010432838407745`*^9}, {
   3.501358610383103*^9, 3.5013586217531185`*^9}, {3.5026774770619183`*^9, 
   3.5026774832519274`*^9}, {3.502677757052311*^9, 3.502677762832319*^9}, {
   3.502765679626664*^9, 3.502765694945891*^9}, {3.502766916862438*^9, 
   3.5027669304188614`*^9}, 3.5027671021907635`*^9, {3.503071895268139*^9, 
   3.5030719155981674`*^9}, {3.50351615772817*^9, 3.5035161598181725`*^9}, {
   3.503856818447089*^9, 3.503856835341919*^9}, {3.5053446929138565`*^9, 
   3.5053446929338565`*^9}, {3.5092398129578204`*^9, 
   3.5092399297864256`*^9}, {3.509240858050456*^9, 3.509240876630089*^9}, {
   3.5094733331253176`*^9, 3.509473337703579*^9}, 3.509475176411747*^9, 
   3.5094752858760085`*^9, {3.509501454231578*^9, 3.5095014624839926`*^9}, {
   3.5095015947098246`*^9, 3.5095015977830305`*^9}, 3.509937960073399*^9, 
   3.5099380786935654`*^9, {3.51016691275181*^9, 3.5101669291418333`*^9}, {
   3.510167526232669*^9, 3.5101675556027107`*^9}, {3.5101684080895686`*^9, 
   3.5101684312332087`*^9}, {3.512076721843137*^9, 3.5120767220331373`*^9}, 
   3.5168207803766356`*^9, {3.517001937691708*^9, 3.517001939875712*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.50267628508025*^9, 3.5026762853502502`*^9}, 
   3.5053450876544085`*^9, 3.512074540564027*^9}],

Cell[TextData[{
 "Rule 1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "C"}], "-", 
       RowBox[{"a", " ", "b", " ", "B"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "A"}]}], "\[NotEqual]", "0"}], " ", 
     "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026766235607233`*^9, 3.502676653910766*^9}, {
   3.5026767649609213`*^9, 3.502676774560935*^9}, {3.5027672387222033`*^9, 
   3.5027672432618113`*^9}, {3.503549718271271*^9, 3.5035497401413016`*^9}, {
   3.504028628528908*^9, 3.504028628903309*^9}, {3.5040318440957556`*^9, 
   3.5040318489317646`*^9}, 3.5043107424584675`*^9, 3.504750503056654*^9, {
   3.509240781672722*^9, 3.5092407958531466`*^9}, {3.510162263655157*^9, 
   3.5101622886308007`*^9}, {3.5101788263270197`*^9, 3.510178829197425*^9}, {
   3.511721416135189*^9, 3.511721416135189*^9}, {3.512076874813351*^9, 
   3.5120768764833536`*^9}, 3.5121850971732745`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "C"}], "-", 
           RowBox[{"a", " ", "b", " ", "B"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"b", " ", "B"}], "+", 
           RowBox[{"a", " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], "A"}], "-", 
              RowBox[{"a", " ", "b", " ", "B"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "C"}], "-", 
              RowBox[{"a", " ", "b", " ", "B"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.5101615196270494`*^9, 3.5101615236518564`*^9}, {3.510161654707687*^9, 
   3.5101616568604903`*^9}, {3.5101619292841697`*^9, 3.510161930812972*^9}, {
   3.510161988657874*^9, 3.5101619894222755`*^9}, {3.5151898848059206`*^9, 
   3.515189886945924*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.509479967012754*^9, 3.5094799793114576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
        RowBox[{"a", "*", "b", "*", "B"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
               RowBox[{"a", "*", "b", "*", "B"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"b", "*", "B"}], "+", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "-", 
            "\[IndentingNewLine]", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}], "-", 
                  RowBox[{"a", "*", "b", "*", "B"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
                  RowBox[{"a", "*", "b", "*", "B"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "-", 
      RowBox[{"a", "*", "b", "*", "B"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, 3.5099379683034105`*^9, 3.5099380917735834`*^9, {
   3.5101623414212933`*^9, 3.5101623830109663`*^9}, {3.5101624144918222`*^9, 
   3.5101624468774786`*^9}, 3.510162528524822*^9, {3.5101626681294675`*^9, 
   3.5101626725442753`*^9}, {3.510162750653612*^9, 3.5101627543196187`*^9}, {
   3.510178835640236*^9, 3.5101788387758417`*^9}, {3.512075876325921*^9, 
   3.512075877245922*^9}, 3.51441169179335*^9, {3.5159797298745136`*^9, 
   3.5159797308885155`*^9}, 3.516666604564042*^9, 3.5168207804166355`*^9, 
   3.516823999314063*^9, 3.5170727002005816`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
               RowBox[{
                RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "A"}], "+", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "-", 
            "\[IndentingNewLine]", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
                  RowBox[{
                   RowBox[{"b", "^", "2"}], "*", "A"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "C"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "A"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5026764690205073`*^9, {3.502676562960639*^9, 3.5026765748706555`*^9}, {
   3.502676709910845*^9, 3.502676745080894*^9}, {3.502677686692212*^9, 
   3.5026776934822216`*^9}, {3.5027670612250915`*^9, 
   3.5027670636898956`*^9}, {3.503071936858197*^9, 3.5030719454782095`*^9}, 
   3.50319810512*^9, {3.503549703821251*^9, 3.503549709891259*^9}, 
   3.50387619429158*^9, {3.5051554747458277`*^9, 3.5051554812558365`*^9}, 
   3.505344641353784*^9, {3.5053446929738564`*^9, 3.505344714963887*^9}, 
   3.505353544425192*^9, {3.50924009739312*^9, 3.509240125441969*^9}, {
   3.509240420719288*^9, 3.509240479234991*^9}, {3.5092405242254696`*^9, 
   3.509240529685479*^9}, 3.509240560292733*^9, 3.5092406309608574`*^9, {
   3.509240739193847*^9, 3.5092407562290773`*^9}, {3.5094733083539004`*^9, 
   3.50947331918552*^9}, {3.509475162067927*^9, 3.509475162249937*^9}, 
   3.509475333159713*^9, {3.5094799670517564`*^9, 3.5094799740681577`*^9}, 
   3.5094800542107415`*^9, {3.5095014684744034`*^9, 3.509501471953209*^9}, {
   3.509501621042671*^9, 3.5095016387643023`*^9}, 3.5099379605633993`*^9, 
   3.509938083863572*^9, {3.5101669135118113`*^9, 3.510166940361849*^9}, 
   3.510167528792673*^9, {3.510167559922716*^9, 3.510167566232725*^9}, {
   3.510167644482835*^9, 3.5101676595628557`*^9}, {3.51016840876037*^9, 
   3.51016843181041*^9}, 3.5101792238641186`*^9, {3.5120767345431547`*^9, 
   3.512076735433156*^9}, 3.516666612020855*^9, 3.516820780436636*^9, 
   3.5168239993390646`*^9, 3.517072704334589*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236216156826`*^9, 3.5017236304920983`*^9}, 
   3.5053451045044327`*^9, 3.512074550564041*^9}],

Cell[TextData[{
 "Rule 2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], ">", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.502677309791684*^9, 3.502677315931693*^9}, {
   3.502767275678668*^9, 3.502767275678668*^9}, {3.5035497928813753`*^9, 
   3.5035497928813753`*^9}, {3.504028634534919*^9, 3.504028634831319*^9}, 
   3.5040318640169907`*^9, 3.504310747731277*^9, {3.5047475946625824`*^9, 
   3.5047475961225843`*^9}, {3.5094724358949986`*^9, 
   3.5094724358949986`*^9}, {3.510163987069785*^9, 3.510163987069785*^9}, {
   3.5101788546410694`*^9, 3.5101788559358716`*^9}, {3.5117214212251964`*^9, 
   3.5117214212251964`*^9}, {3.5120768878933697`*^9, 3.5120768878933697`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
       FractionBox[
        RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "-", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "C", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "-", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{"A", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "B"}], "-", 
              RowBox[{"a", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5101642321454153`*^9, 3.5101642363106227`*^9}, {
   3.5101642797722993`*^9, 3.5101643150283613`*^9}, {3.5101646049236703`*^9, 
   3.5101646129576845`*^9}, {3.5151898918659306`*^9, 
   3.5151898944059343`*^9}, {3.516854130156975*^9, 3.5168541382504377`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "B"}], "-", 
                  RowBox[{"a", "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, 
   3.5099379687634115`*^9, 3.509938092433584*^9, {3.5101624762211304`*^9, 
   3.5101624923515587`*^9}, {3.5101640447742863`*^9, 3.51016406980913*^9}, 
   3.5101641131772065`*^9, {3.5101641448296623`*^9, 3.51016414941607*^9}, {
   3.51016509104202*^9, 3.5101651240820665`*^9}, {3.510165159142115*^9, 
   3.5101651866821537`*^9}, {3.5101788644534864`*^9, 
   3.5101788659978895`*^9}, {3.512075842745874*^9, 3.512075858355896*^9}, {
   3.51207599006608*^9, 3.512075992776084*^9}, {3.515979735162923*^9, 
   3.5159797361145244`*^9}, 3.516666617231264*^9, 3.516820780476636*^9, 
   3.5168239993770666`*^9, {3.5168541477059784`*^9, 3.5168541547533817`*^9}, 
   3.517072707626195*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
     "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}], "+", "1"}], ")"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}], "+", "1"}], ")"}]}], 
        ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "-", "\n", 
            "        ", 
            RowBox[{"a", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, 3.50267709922139*^9, {3.502677262251618*^9, 
   3.502677280331643*^9}, 3.5027670673403025`*^9, {3.5030150059333043`*^9, 
   3.5030150148565197`*^9}, {3.503071953798221*^9, 3.5030719623082333`*^9}, {
   3.5035497609313307`*^9, 3.5035497734613485`*^9}, 3.503876194868781*^9, {
   3.504156461196662*^9, 3.5041564626786647`*^9}, 3.505344641373784*^9, {
   3.5053446930538564`*^9, 3.505344714983887*^9}, 3.5053535482551975`*^9, {
   3.5094719943757453`*^9, 3.509471999082014*^9}, {3.5094721711418557`*^9, 
   3.5094721778162374`*^9}, {3.50947240515324*^9, 3.509472413765733*^9}, 
   3.5094733026345735`*^9, {3.509475150960292*^9, 3.5094751544394903`*^9}, {
   3.509501480299224*^9, 3.5095014852600327`*^9}, {3.5095016962152033`*^9, 
   3.5095017075096235`*^9}, 3.5099379609934006`*^9, 3.509938084533573*^9, 
   3.5101669141118126`*^9, {3.510166944761855*^9, 3.510166945361856*^9}, 
   3.5101675315326767`*^9, {3.510167572462734*^9, 3.5101675741527367`*^9}, {
   3.5101676727628746`*^9, 3.510167700682914*^9}, {3.5101678663631454`*^9, 
   3.5101678684931483`*^9}, {3.510168409399971*^9, 3.5101684322472105`*^9}, 
   3.5101792316017323`*^9, 3.5120767523631797`*^9, 3.5166666210844707`*^9, 
   3.516820780496636*^9, 3.5168239994000683`*^9, 3.5170727093109975`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.501723667776164*^9, 3.501723669304967*^9}, 
   3.505345123374459*^9, 3.5120745604840546`*^9}],

Cell[TextData[{
 "Note: Rule 4 is used if ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "k", " ", "m"}], "=", 
   RowBox[{"k", "=", 
    RowBox[{"-", "1"}]}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.501723667776164*^9, 3.501723669304967*^9}, 
   3.505345123374459*^9, 3.5120745604840546`*^9, {3.5152086988575835`*^9, 
   3.51520877052411*^9}}],

Cell[TextData[{
 "Rule 3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"\[Not]", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["m", "2"], "=", 
        RowBox[{
         RowBox[{"1", " ", "\[And]", " ", "k"}], "=", 
         RowBox[{"-", "1"}]}]}], ")"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.4993685152127995`*^9, 3.499368525272814*^9}, {3.5003196739046497`*^9, 
   3.5003196775646553`*^9}, {3.5004320218638687`*^9, 
   3.5004320229179287`*^9}, {3.5026773276717095`*^9, 
   3.5026773598217545`*^9}, {3.5027672801246758`*^9, 
   3.5027672801246758`*^9}, {3.5040286397141275`*^9, 
   3.5040286407749295`*^9}, {3.5040290157527885`*^9, 3.5040290170787907`*^9}, 
   3.5040318675893974`*^9, {3.504296981415786*^9, 3.5042969896257973`*^9}, 
   3.5043107563112917`*^9, {3.5047476042825956`*^9, 3.5047476056225977`*^9}, {
   3.5051011018466954`*^9, 3.5051011152867146`*^9}, {3.5094725039578915`*^9, 
   3.5094725039578915`*^9}, {3.510163990798191*^9, 3.510163990798191*^9}, {
   3.5101789900961075`*^9, 3.5101789905485077`*^9}, {3.510938862411886*^9, 
   3.510938862411886*^9}, {3.511721428135206*^9, 3.511721428135206*^9}, {
   3.5120768992933855`*^9, 3.5120769014833884`*^9}, {3.515208667111528*^9, 
   3.5152086757383432`*^9}, {3.5170030981493473`*^9, 3.517003103609357*^9}, {
   3.517003269219248*^9, 3.517003269219248*^9}, {3.517003329201353*^9, 
   3.5170033475937853`*^9}, {3.517007980788726*^9, 3.517007982036728*^9}, {
   3.517072820473593*^9, 3.5170728209103937`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"], "+", "n"}], ")"}]}]]}]}]}]}]}], 
  "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "3"}], "2"], "+", "n"}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "+", 
           RowBox[{"a", " ", "B"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "+", 
              RowBox[{"a", " ", "B"}], "+", 
              RowBox[{"b", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"], "+", "n"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "C", " ", "n"}], "+", 
           RowBox[{"b", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "3"}], "2"], "+", "n"}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5101642388066273`*^9, 3.5101642424102335`*^9}, {3.510164334543995*^9, 
   3.5101643769916697`*^9}, {3.5151898992659407`*^9, 3.515189902415945*^9}, {
   3.5168540216867704`*^9, 3.5168540416109104`*^9}, {3.5168544724095507`*^9, 
   3.516854590711317*^9}, {3.517005568748488*^9, 3.517005650133831*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}], "+", "n"}], ")"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "3"}], ")"}], "/", "2"}], "+", "n"}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{"a", "*", "B"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"a", "*", "B"}], "+", 
                  RowBox[{"b", "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}], "+", "n"}], 
                 ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "C", "*", "n"}], "+", 
               RowBox[{"b", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}], "+", "n"}], 
                 ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "^", "2"}], "\[Equal]", "1"}], " ", "&&", " ", 
      RowBox[{"k", "\[Equal]", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, 
   3.509937969193412*^9, 3.5099380930635853`*^9, {3.51016249317836*^9, 
   3.5101624940051613`*^9}, {3.5101640473482904`*^9, 3.51016407531594*^9}, 
   3.510164116624812*^9, {3.510164152848076*^9, 3.51016415535968*^9}, {
   3.510165191632161*^9, 3.510165194222164*^9}, {3.5101653771224203`*^9, 
   3.5101654229124846`*^9}, 3.510178994011714*^9, 3.5109329428883476`*^9, {
   3.5109334145587764`*^9, 3.510933431422406*^9}, {3.5109361148240366`*^9, 
   3.5109361164940386`*^9}, 3.5109385788314896`*^9, {3.5120757833657913`*^9, 
   3.5120757871657963`*^9}, 3.515208655364707*^9, {3.515979741184533*^9, 
   3.515979742198535*^9}, {3.5165684096082325`*^9, 3.516568415928241*^9}, {
   3.516571060077979*^9, 3.5165710860380154`*^9}, 3.5166666278548827`*^9, 
   3.516820780546636*^9, 3.5168239994430704`*^9, {3.516854051887498*^9, 
   3.516854070723575*^9}, 3.516854429338087*^9, 3.516854607396271*^9, {
   3.516933832508247*^9, 3.5169338363770533`*^9}, {3.5169338703539133`*^9, 
   3.5169338932859535`*^9}, {3.5169843974420533`*^9, 3.5169844049120636`*^9}, 
   3.5169846782824464`*^9, {3.517003078774113*^9, 3.5170030905989337`*^9}, 
   3.5170031813910933`*^9, {3.517003222138365*^9, 3.5170032240415683`*^9}, {
   3.5170056545642385`*^9, 3.5170056865598946`*^9}, {3.5170080108811784`*^9, 
   3.5170080120355806`*^9}, 3.517072712306203*^9, 3.5170764559043303`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}], "+", "n"}], ")"}]}], 
       ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "3"}], ")"}], "/", "2"}], "+", "n"}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "A"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "+", 
                  RowBox[{"b", "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}], "+", "n"}], 
                 ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", "\n", 
            "        ", 
            RowBox[{"a", "*", "C", "*", "n", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "^", "2"}], "\[Equal]", "1"}], " ", "&&", " ", 
      RowBox[{"k", "\[Equal]", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.509501492451645*^9, 3.50950149522845*^9}, {3.5095017530305033`*^9, 
   3.5095017758065434`*^9}, 3.509937961403401*^9, 3.509938085113574*^9, 
   3.510166914701813*^9, {3.5101669527718663`*^9, 3.5101669533818674`*^9}, 
   3.51016753384268*^9, {3.5101675779927416`*^9, 3.5101675799127445`*^9}, {
   3.510167714862933*^9, 3.5101677293029537`*^9}, {3.5101678808031654`*^9, 
   3.510167883343169*^9}, {3.510168410055172*^9, 3.510168432652811*^9}, 
   3.5101792429897523`*^9, {3.5109362478842225`*^9, 3.510936262544243*^9}, 
   3.5109386140615387`*^9, {3.5120767677432013`*^9, 3.512076768343202*^9}, {
   3.515208514137659*^9, 3.515208521828473*^9}, {3.515208610842229*^9, 
   3.515208619781045*^9}, {3.51656842234825*^9, 3.516568425798255*^9}, {
   3.5165710889680195`*^9, 3.5165710905080214`*^9}, {3.5165711432080956`*^9, 
   3.5165711448180976`*^9}, 3.516666632722091*^9, 3.516820780566636*^9, 
   3.5168239994670715`*^9, {3.516854079578082*^9, 3.5168540820462227`*^9}, 
   3.5168544316352186`*^9, 3.5168548747125607`*^9, 3.5168549354870367`*^9, {
   3.517003137492616*^9, 3.517003192997514*^9}, {3.5170057003815193`*^9, 
   3.517005732798376*^9}, {3.5170079912875443`*^9, 3.5170079925355463`*^9}, 
   3.5170727142562065`*^9, 3.5170764606843367`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Recurrence 4", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, 3.5053450876544085`*^9, 3.5120745708040695`*^9}],

Cell[TextData[{
 "Rule 4: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", 
     " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.504028644986937*^9, 3.5040286460633388`*^9}, 
   3.504031871520604*^9, {3.5042969469757376`*^9, 3.504296966725765*^9}, 
   3.5043107598680983`*^9, {3.504747625602626*^9, 3.5047476267926273`*^9}, {
   3.5051010704066515`*^9, 3.505101092536682*^9}, {3.5094730728464303`*^9, 
   3.5094730728464303`*^9}, {3.510163994448598*^9, 3.510163994448598*^9}, {
   3.5101789459480295`*^9, 3.5101789495984364`*^9}, {3.5109388910119267`*^9, 
   3.5109388910119267`*^9}, {3.511721434475215*^9, 3.511721434475215*^9}, {
   3.512076908163398*^9, 3.512076909243399*^9}, {3.5152083555165806`*^9, 
   3.5152083859522343`*^9}, {3.516666712469431*^9, 3.5166667226874495`*^9}, {
   3.5170031257613955`*^9, 3.5170031257613955`*^9}, {3.517003272932054*^9, 
   3.517003272932054*^9}, {3.5170079876215377`*^9, 3.5170079887915397`*^9}, {
   3.5170729115309534`*^9, 3.517072916694562*^9}, {3.517072958736636*^9, 
   3.517072958736636*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", " ", "A"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "A"}], "+", 
              RowBox[{"a", " ", "C"}], "+", 
              RowBox[{"b", " ", "B"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", " ", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"2", "k"}]]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5101642451402383`*^9, 3.5101642493366456`*^9}, {3.5101644045413184`*^9, 
   3.510164447176193*^9}, {3.510164586047637*^9, 3.5101645942844515`*^9}, {
   3.515189907565953*^9, 3.5151899095159554`*^9}, {3.5168547494853983`*^9, 
   3.516854772157695*^9}, {3.5170057456527987`*^9, 3.517005768631639*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3